/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.invoker;

import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.AppContext;
import net.hasor.core.Hasor;
import net.hasor.utils.Iterators;
import net.hasor.utils.future.BasicFuture;
import net.hasor.web.Invoker;
import net.hasor.web.InvokerConfig;
import net.hasor.web.Mapping;
import net.hasor.web.MappingDiscoverer;
import net.hasor.web.definition.AbstractDefinition;
import net.hasor.web.invoker.ExceuteCaller;
import net.hasor.web.invoker.InMappingDef;
import net.hasor.web.invoker.InvokerCaller;
import net.hasor.web.invoker.InvokerChainInvocation;
import net.hasor.web.invoker.InvokerSupplier;
import net.hasor.web.invoker.RootInvokerCreater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokerContext {
    protected static Logger logger = LoggerFactory.getLogger(InvokerContext.class);
    private AppContext appContext = null;
    private Mapping[] invokeArray = new Mapping[0];
    private AbstractDefinition[] filters = new AbstractDefinition[0];
    private RootInvokerCreater invokerCreater = null;

    public void initContext(final AppContext appContext, Map<String, String> configMap) throws Throwable {
        this.appContext = (AppContext)Hasor.assertIsNotNull((Object)appContext);
        List mappingList = appContext.findBindingBean(InMappingDef.class);
        mappingList.sort(Comparator.comparingLong(InMappingDef::getIndex));
        for (Mapping inMapping : this.invokeArray = mappingList.toArray(new Mapping[0])) {
            logger.info("mapingTo -> type \u2018{}\u2019 mappingTo: \u2018{}\u2019.", (Object)inMapping.getTargetType().getBindType(), (Object)inMapping.getMappingTo());
        }
        List setupList = appContext.findBindingBean(MappingDiscoverer.class);
        for (MappingDiscoverer setup : setupList) {
            for (Mapping mapping : this.invokeArray) {
                setup.discover(mapping);
            }
        }
        final Map<String, String> config = Collections.unmodifiableMap(new HashMap<String, String>(configMap));
        InvokerConfig filterConfig = new InvokerConfig(){

            @Override
            public String getInitParameter(String name) {
                return (String)config.get(name);
            }

            @Override
            public Enumeration<String> getInitParameterNames() {
                return Iterators.asEnumeration(config.keySet().iterator());
            }

            @Override
            public AppContext getAppContext() {
                return appContext;
            }
        };
        this.filters = (AbstractDefinition[])appContext.findBindingBean(AbstractDefinition.class).stream().sorted(Comparator.comparingLong(AbstractDefinition::getIndex)).toArray(AbstractDefinition[]::new);
        for (AbstractDefinition filter : this.filters) {
            filter.init(filterConfig);
        }
        this.invokerCreater = new RootInvokerCreater(appContext);
    }

    public void destroyContext() {
        for (AbstractDefinition filter : this.filters) {
            filter.destroy();
        }
    }

    public Invoker newInvoker(Mapping define, HttpServletRequest request, HttpServletResponse response) {
        return this.invokerCreater.createExt(new InvokerSupplier(define, this.appContext, request, response));
    }

    public ExceuteCaller genCaller(HttpServletRequest httpReq, HttpServletResponse httpRes) {
        Mapping foundDefine = null;
        for (Mapping define : this.invokeArray) {
            if (!define.matchingMapping(httpReq)) continue;
            foundDefine = define;
            break;
        }
        Invoker invoker = this.newInvoker(foundDefine, httpReq, httpRes);
        if (foundDefine == null) {
            return chain -> {
                BasicFuture future = new BasicFuture();
                future.completed(new InvokerChainInvocation(this.filters, innerInv -> {
                    if (chain != null) {
                        chain.doFilter((ServletRequest)innerInv.getHttpRequest(), (ServletResponse)innerInv.getHttpResponse());
                    }
                    return innerInv.get("resultData");
                }).doNext(invoker));
                return future;
            };
        }
        return new InvokerCaller(() -> invoker, this.filters);
    }
}

