/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.invoker;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.hasor.utils.BeanUtils;
import net.hasor.utils.StringUtils;
import net.hasor.utils.convert.ConverterUtils;
import net.hasor.web.Invoker;
import net.hasor.web.Mapping;
import net.hasor.web.annotation.AttributeParameter;
import net.hasor.web.annotation.CookieParameter;
import net.hasor.web.annotation.HeaderParameter;
import net.hasor.web.annotation.IgnoreParam;
import net.hasor.web.annotation.ParameterForm;
import net.hasor.web.annotation.PathParameter;
import net.hasor.web.annotation.QueryParameter;
import net.hasor.web.annotation.RequestParameter;
import net.hasor.web.annotation.WebParameter;
import net.hasor.web.invoker.InvokerCaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokerCallerParamsBuilder {
    protected static Logger logger = LoggerFactory.getLogger(InvokerCaller.class);
    private Map<String, List<String>> queryParamLocal = null;
    private Map<String, Object> pathParamsLocal = null;

    public Object[] resolveParams(Invoker invoker, Method targetMethod) throws Throwable {
        Class<?>[] targetParamClass = targetMethod.getParameterTypes();
        Annotation[][] targetParamAnno = targetMethod.getParameterAnnotations();
        targetParamAnno = targetParamAnno == null ? new Annotation[0][0] : targetParamAnno;
        ArrayList<Object> paramsArray = new ArrayList<Object>();
        for (int i = 0; i < targetParamClass.length; ++i) {
            Class<?> paramClass = targetParamClass[i];
            Object paramObject = this.resolveParam(invoker, paramClass, targetParamAnno[i]);
            paramsArray.add(paramObject);
        }
        return paramsArray.toArray();
    }

    private Object resolveParam(Invoker invoker, Class<?> paramClass, Annotation[] paramAnno) {
        Object specialParam = this.resolveSpecialParam(invoker, paramClass);
        if (specialParam != null) {
            return specialParam;
        }
        for (Annotation pAnno : paramAnno) {
            if (pAnno.annotationType().getAnnotation(WebParameter.class) == null) continue;
            Object finalValue = this.resolveParam(invoker, paramClass, pAnno);
            if ((finalValue = ConverterUtils.convert(paramClass, (Object)finalValue)) == null) continue;
            return finalValue;
        }
        return BeanUtils.getDefaultValue(paramClass);
    }

    private Object resolveSpecialParam(Invoker invoker, Class<?> paramClass) {
        if (!paramClass.isInterface()) {
            return null;
        }
        if (paramClass == ServletRequest.class || paramClass == HttpServletRequest.class) {
            return invoker.getHttpRequest();
        }
        if (paramClass == ServletResponse.class || paramClass == HttpServletResponse.class) {
            return invoker.getHttpResponse();
        }
        if (paramClass == HttpSession.class) {
            return invoker.getHttpRequest().getSession(true);
        }
        if (paramClass == Invoker.class) {
            return invoker;
        }
        if (paramClass.isInstance(invoker)) {
            return invoker;
        }
        return null;
    }

    private Object resolveParam(Invoker invoker, Class<?> paramClass, Annotation pAnno) {
        Object atData = null;
        if (pAnno instanceof AttributeParameter) {
            atData = this.getAttributeParam(invoker, (AttributeParameter)pAnno);
        } else if (pAnno instanceof CookieParameter) {
            atData = this.getCookieParam(invoker, (CookieParameter)pAnno);
        } else if (pAnno instanceof HeaderParameter) {
            atData = this.getHeaderParam(invoker, (HeaderParameter)pAnno);
        } else if (pAnno instanceof QueryParameter) {
            atData = this.getQueryParam(invoker, (QueryParameter)pAnno);
        } else if (pAnno instanceof PathParameter) {
            atData = this.getPathParam(invoker, (PathParameter)pAnno);
        } else if (pAnno instanceof RequestParameter) {
            atData = invoker.getHttpRequest().getParameterValues(((RequestParameter)pAnno).value());
        } else if (pAnno instanceof ParameterForm) {
            try {
                atData = this.getParamsParam(invoker, paramClass, paramClass.newInstance());
            }
            catch (Throwable e) {
                logger.error(paramClass.getName() + "newInstance error.", (Object)e.getMessage());
                atData = null;
            }
        }
        return atData;
    }

    public <T> T getParamsParam(Invoker invoker, Class<? extends T> paramClass, T paramObject) {
        if (paramObject == null) {
            return null;
        }
        List fieldList = BeanUtils.findALLFields(paramClass);
        if (fieldList == null || fieldList.isEmpty()) {
            return paramObject;
        }
        for (Field field : fieldList) {
            if (field.isAnnotationPresent(IgnoreParam.class)) {
                logger.debug(field + " -> Ignore.");
                continue;
            }
            try {
                Object fieldValue = null;
                Annotation[] annos = field.getAnnotations();
                fieldValue = annos == null || annos.length == 0 ? invoker.getHttpRequest().getParameterValues(field.getName()) : this.resolveParam(invoker, field.getType(), annos);
                if (fieldValue == null) {
                    fieldValue = BeanUtils.getDefaultValue(field.getType());
                }
                fieldValue = ConverterUtils.convert(field.getType(), (Object)fieldValue);
                field.setAccessible(true);
                field.set(paramObject, fieldValue);
            }
            catch (Exception e) {
                logger.error(field + "set new Value error.", (Object)e.getMessage());
            }
        }
        return paramObject;
    }

    private Object getPathParam(Invoker invoker, PathParameter pAnno) {
        String paramName = pAnno.value();
        return StringUtils.isBlank((String)paramName) ? null : this.getPathParamMap(invoker).get(paramName);
    }

    private Object getQueryParam(Invoker invoker, QueryParameter pAnno) {
        String paramName = pAnno.value();
        return StringUtils.isBlank((String)paramName) ? null : this.getQueryParamMap(invoker).get(paramName);
    }

    private Object getHeaderParam(Invoker invoker, HeaderParameter pAnno) {
        String paramName = pAnno.value();
        if (StringUtils.isBlank((String)paramName)) {
            return null;
        }
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        Enumeration e = httpRequest.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement().toString();
            if (!name.equalsIgnoreCase(paramName)) continue;
            ArrayList headerList = new ArrayList();
            Enumeration v = httpRequest.getHeaders(paramName);
            while (v.hasMoreElements()) {
                headerList.add(v.nextElement());
            }
            return headerList;
        }
        return null;
    }

    private Object getCookieParam(Invoker invoker, CookieParameter pAnno) {
        String paramName = pAnno.value();
        if (StringUtils.isBlank((String)paramName)) {
            return null;
        }
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        Cookie[] cookies = httpRequest.getCookies();
        ArrayList<String> cookieList = new ArrayList<String>();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String cookieName = cookie.getName();
                if (cookieName == null || !cookieName.equalsIgnoreCase(paramName)) continue;
                cookieList.add(cookie.getValue());
            }
        }
        return cookieList;
    }

    private Object getAttributeParam(Invoker invoker, AttributeParameter pAnno) {
        String paramName = pAnno.value();
        if (StringUtils.isBlank((String)paramName)) {
            return null;
        }
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        Enumeration e = httpRequest.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement().toString();
            if (!name.equalsIgnoreCase(paramName)) continue;
            return httpRequest.getAttribute(paramName);
        }
        return null;
    }

    private Map<String, List<String>> getQueryParamMap(Invoker invoker) {
        String[] params;
        if (this.queryParamLocal != null) {
            return this.queryParamLocal;
        }
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        String queryString = httpRequest.getQueryString();
        if (StringUtils.isBlank((String)queryString)) {
            return Collections.EMPTY_MAP;
        }
        this.queryParamLocal = new HashMap<String, List<String>>();
        String[] stringArray = params = queryString.split("&");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String oriData;
            block6: {
                String pData;
                oriData = pData = stringArray[i];
                String encoding = httpRequest.getCharacterEncoding();
                try {
                    if (encoding == null) break block6;
                    oriData = URLDecoder.decode(pData, encoding);
                }
                catch (Exception e) {
                    logger.warn("use \u2018{}\u2019 decode \u2018{}\u2019 error.", (Object)encoding, (Object)pData);
                    continue;
                }
            }
            String[] kv = oriData.split("=");
            if (kv.length < 2) continue;
            String k = kv[0].trim();
            String v = kv[1];
            ArrayList<String> pArray = this.queryParamLocal.get(k);
            ArrayList<String> arrayList = pArray = pArray == null ? new ArrayList<String>() : pArray;
            if (!pArray.contains(v)) {
                pArray.add(v);
            }
            this.queryParamLocal.put(k, pArray);
        }
        return this.queryParamLocal;
    }

    private Map<String, Object> getPathParamMap(Invoker invoker) {
        if (this.pathParamsLocal != null) {
            return this.pathParamsLocal;
        }
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        Mapping ownerMapping = invoker.ownerMapping();
        if (ownerMapping == null) {
            return Collections.EMPTY_MAP;
        }
        String requestPath = httpRequest.getRequestURI().substring(httpRequest.getContextPath().length());
        String matchVar = ownerMapping.getMappingToMatches();
        String matchKey = "(?:\\{(\\w+)\\}){1,}";
        Matcher keyM = Pattern.compile(matchKey).matcher(ownerMapping.getMappingTo());
        Matcher varM = Pattern.compile(matchVar).matcher(requestPath);
        ArrayList<String> keyArray = new ArrayList<String>();
        ArrayList<String> varArray = new ArrayList<String>();
        while (keyM.find()) {
            keyArray.add(keyM.group(1));
        }
        varM.find();
        for (int i = 1; i <= varM.groupCount(); ++i) {
            varArray.add(varM.group(i));
        }
        HashMap<String, List> uriParams = new HashMap<String, List>();
        for (int i = 0; i < keyArray.size(); ++i) {
            String k = (String)keyArray.get(i);
            String v = (String)varArray.get(i);
            List pArray = (List)uriParams.get(k);
            List list = pArray = pArray == null ? new ArrayList() : pArray;
            if (!pArray.contains(v)) {
                pArray.add(v);
            }
            uriParams.put(k, pArray);
        }
        this.pathParamsLocal = new HashMap<String, Object>();
        for (Map.Entry ent : uriParams.entrySet()) {
            String k = (String)ent.getKey();
            List v = (List)ent.getValue();
            this.pathParamsLocal.put(k, v.toArray(new String[0]));
        }
        return this.pathParamsLocal;
    }
}

