/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.valid;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.hasor.web.Invoker;
import net.hasor.web.InvokerData;
import net.hasor.web.Mapping;
import net.hasor.web.MappingDiscoverer;
import net.hasor.web.WebApiBinder;
import net.hasor.web.WebModule;
import net.hasor.web.WebPlugin;
import net.hasor.web.valid.ValidDefinition;
import net.hasor.web.valid.ValidInvoker;

public class ValidWebPlugin
implements WebModule,
WebPlugin,
MappingDiscoverer {
    private Map<Method, ValidDefinition> validMapping = null;

    @Override
    public void loadModule(WebApiBinder apiBinder) throws Throwable {
        apiBinder.addPlugin(this);
        apiBinder.addDiscoverer(this);
        this.validMapping = new HashMap<Method, ValidDefinition>();
    }

    @Override
    public void discover(Mapping mappingData) {
        String[] httpMethodSet;
        for (String m : httpMethodSet = mappingData.getHttpMethodSet()) {
            Method objMethod = mappingData.getHttpMethod(m);
            if (this.validMapping.containsKey(objMethod)) continue;
            this.validMapping.put(objMethod, new ValidDefinition(objMethod));
        }
    }

    @Override
    public void beforeFilter(Invoker invoker, InvokerData define) {
        ValidDefinition valid = this.validMapping.get(define.targetMethod());
        if (valid == null || !valid.isEnable() || !(invoker instanceof ValidInvoker)) {
            return;
        }
        ValidInvoker errors = (ValidInvoker)invoker;
        Object[] resolveParams = define.getParameters();
        valid.doValid(invoker.getAppContext(), errors, resolveParams);
    }

    @Override
    public void afterFilter(Invoker invoker, InvokerData define) {
    }
}

