/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.valid;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.hasor.core.AppContext;
import net.hasor.web.valid.Valid;
import net.hasor.web.valid.ValidBy;
import net.hasor.web.valid.ValidInvoker;
import net.hasor.web.valid.ValidStrategy;
import net.hasor.web.valid.Validation;

class ValidDefinition {
    private boolean enable = false;
    private Map<String, Valid> paramValidMap = new HashMap<String, Valid>();
    private Map<String, Class<?>> paramTypeMap = new HashMap();

    public ValidDefinition(Method targetMethod) {
        Annotation[][] paramAnno = targetMethod.getParameterAnnotations();
        Class<?>[] paramType = targetMethod.getParameterTypes();
        for (int paramIndex = 0; paramIndex < paramAnno.length; ++paramIndex) {
            Annotation[] annoArrays;
            for (Annotation anno : annoArrays = paramAnno[paramIndex]) {
                if (anno == null || !(anno instanceof Valid)) continue;
                this.paramValidMap.put(String.valueOf(paramIndex), (Valid)anno);
                this.paramTypeMap.put(String.valueOf(paramIndex), paramType[paramIndex]);
            }
        }
        this.enable = !this.paramTypeMap.isEmpty();
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void doValid(AppContext appContext, ValidInvoker data, Object[] resolveParams) {
        if (!this.enable) {
            return;
        }
        for (String paramIndex : this.paramValidMap.keySet()) {
            this.doValidParam(appContext, data, paramIndex, resolveParams[Integer.valueOf(paramIndex)]);
        }
    }

    private void doValidParam(AppContext appContext, ValidInvoker data, String paramIndex, Object paramObject) {
        Valid paramValid = this.paramValidMap.get(paramIndex);
        if (paramValid == null) {
            return;
        }
        String sceneName = paramValid.value();
        Class<?> paramType = this.paramTypeMap.get(paramIndex);
        HashSet<Class<? extends Validation>> validList = new HashSet<Class<? extends Validation>>();
        int loopIndex = 0;
        do {
            ValidBy validBy;
            if ((validBy = paramType.getAnnotation(ValidBy.class)) != null) {
                if (validBy.value().length == 0) {
                    data.addError(sceneName, paramType + " validType is Undefined.");
                }
                if (loopIndex == 0 || validBy.inherited()) {
                    validList.addAll(Arrays.asList(validBy.value()));
                }
            }
            paramType = paramType.getSuperclass();
            ++loopIndex;
        } while (paramType != null);
        for (Class clazz : validList) {
            Validation validObject = (Validation)appContext.getInstance(clazz);
            if (validObject == null) {
                data.addError(sceneName, "Validation program is not exist. [" + clazz + "]");
                continue;
            }
            ValidStrategy validStrategy = validObject.doValidation(sceneName, paramObject, data);
            if (!ValidStrategy.EXIT_EXECUTION.equals((Object)validStrategy)) continue;
            break;
        }
    }
}

