/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.startup;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.AppContext;
import net.hasor.utils.ExceptionUtils;
import net.hasor.utils.StringUtils;
import net.hasor.web.Invoker;
import net.hasor.web.ServletVersion;
import net.hasor.web.invoker.ExceuteCaller;
import net.hasor.web.invoker.InvokerContext;
import net.hasor.web.startup.RuntimeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeFilter
implements Filter {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicBoolean inited = new AtomicBoolean(false);
    public static final String HTTP_REQUEST_ENCODING_KEY = "HTTP_REQUEST_ENCODING";
    public static final String HTTP_RESPONSE_ENCODING_KEY = "HTTP_RESPONSE_ENCODING";
    private String httpRequestEncoding = null;
    private String httpResponseEncoding = null;
    private AppContext appContext = null;
    private InvokerContext invokerContext = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        if (!this.inited.compareAndSet(false, true)) {
            return;
        }
        HashMap<String, String> configMap = new HashMap<String, String>();
        Enumeration names = filterConfig.getInitParameterNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String name = names.nextElement().toString();
                configMap.put(name, filterConfig.getInitParameter(name));
            }
        }
        AppContext appContext = RuntimeListener.getAppContext(filterConfig.getServletContext());
        this.httpRequestEncoding = (String)appContext.findBindingBean(HTTP_REQUEST_ENCODING_KEY, String.class);
        this.httpResponseEncoding = (String)appContext.findBindingBean(HTTP_RESPONSE_ENCODING_KEY, String.class);
        try {
            this.appContext = appContext;
            this.invokerContext = new InvokerContext();
            this.invokerContext.initContext(appContext, configMap);
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Throwable e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
        if (ServletVersion.V2_5.le((ServletVersion)((Object)this.appContext.getInstance(ServletVersion.class)))) {
            this.logger.info("RuntimeFilter started, at {}", (Object)filterConfig.getServletContext().getServerInfo());
        } else {
            this.logger.info("RuntimeFilter started, context at {}", (Object)filterConfig.getServletContext().getContextPath());
        }
    }

    public void destroy() {
        this.invokerContext.destroyContext();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq = (HttpServletRequest)request;
        HttpServletResponse httpRes = (HttpServletResponse)response;
        if (StringUtils.isNotBlank((String)this.httpRequestEncoding)) {
            httpReq.setCharacterEncoding(this.httpRequestEncoding);
        }
        if (StringUtils.isNotBlank((String)this.httpResponseEncoding)) {
            httpRes.setCharacterEncoding(this.httpResponseEncoding);
        }
        try {
            this.beforeRequest(this.appContext, httpReq, httpRes);
            this.doFilter(chain, httpReq, httpRes);
        }
        catch (Throwable e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
        finally {
            this.afterResponse(this.appContext, httpReq, httpRes);
        }
    }

    private void doFilter(FilterChain chain, HttpServletRequest httpReq, HttpServletResponse httpRes) throws IOException, ServletException {
        try {
            Invoker invoker = this.invokerContext.newInvoker(httpReq, httpRes);
            ExceuteCaller caller = this.invokerContext.genCaller(invoker);
            if (caller != null) {
                Future<Object> resultData = caller.invoke(invoker, chain);
                if (resultData != null && resultData.isDone()) {
                    resultData.get();
                }
            } else {
                chain.doFilter((ServletRequest)httpReq, (ServletResponse)httpRes);
            }
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof ServletException) {
                throw (ServletException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw ExceptionUtils.toRuntimeException((Throwable)cause);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Throwable e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
    }

    protected void beforeRequest(AppContext appContext, HttpServletRequest httpReq, HttpServletResponse httpRes) {
    }

    protected void afterResponse(AppContext appContext, HttpServletRequest httpReq, HttpServletResponse httpRes) {
    }
}

