/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.render;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.AppContext;
import net.hasor.core.Settings;
import net.hasor.utils.StringUtils;
import net.hasor.web.Invoker;
import net.hasor.web.InvokerChain;
import net.hasor.web.InvokerConfig;
import net.hasor.web.InvokerData;
import net.hasor.web.InvokerFilter;
import net.hasor.web.RenderEngine;
import net.hasor.web.RenderInvoker;
import net.hasor.web.WebApiBinder;
import net.hasor.web.WebModule;
import net.hasor.web.WebPlugin;
import net.hasor.web.annotation.Produces;
import net.hasor.web.definition.RenderDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderWebPlugin
implements WebModule,
WebPlugin,
InvokerFilter {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private AtomicBoolean inited = new AtomicBoolean(false);
    private String layoutPath = null;
    private boolean useLayout = true;
    private String templatePath = null;
    private Map<String, RenderEngine> engineMap = null;
    private String placeholder = null;
    private String defaultLayout = null;

    @Override
    public void loadModule(WebApiBinder apiBinder) throws Throwable {
        apiBinder.addPlugin(this);
        apiBinder.filter("/*", new String[0]).through(Integer.MAX_VALUE, this);
    }

    @Override
    public void init(InvokerConfig config) throws Throwable {
        if (!this.inited.compareAndSet(false, true)) {
            return;
        }
        AppContext appContext = config.getAppContext();
        HashMap<String, RenderEngine> engineMap = new HashMap<String, RenderEngine>();
        HashMap<String, String> renderMapping = new HashMap<String, String>();
        List renderInfoList = appContext.findBindingBean(RenderDefinition.class);
        for (RenderDefinition renderInfo : renderInfoList) {
            if (renderInfo == null) continue;
            this.logger.info("web -> renderType {} mappingTo {}.", (Object)StringUtils.join((Object[])renderInfo.getRenderSet().toArray(), (String)","), (Object)renderInfo.toString());
            String renderInfoID = renderInfo.getID();
            engineMap.put(renderInfoID, renderInfo.newEngine(appContext));
            List<String> renderSet = renderInfo.getRenderSet();
            for (String renderName : renderSet) {
                renderMapping.put(renderName.toUpperCase(), renderInfoID);
            }
        }
        this.engineMap = new HashMap<String, RenderEngine>();
        for (String key : renderMapping.keySet()) {
            String keyMapping = (String)renderMapping.get(key);
            RenderEngine engine = (RenderEngine)engineMap.get(keyMapping);
            this.engineMap.put(key, engine);
        }
        Settings settings = appContext.getEnvironment().getSettings();
        this.useLayout = settings.getBoolean("hasor.layout.enable", Boolean.valueOf(true));
        this.layoutPath = settings.getString("hasor.layout.layoutPath", "/layout");
        this.templatePath = settings.getString("hasor.layout.templatePath", "/templates");
        this.placeholder = settings.getString("hasor.layout.placeholder", "content_placeholder");
        this.defaultLayout = settings.getString("hasor.layout.defaultLayout", "default.htm");
        this.logger.info("RenderPlugin init -> useLayout={}, layoutPath={}, templatePath={}, placeholder={}, defaultLayout={}", new Object[]{this.useLayout, this.layoutPath, this.templatePath, this.placeholder, this.defaultLayout});
    }

    @Override
    public void destroy() {
    }

    @Override
    public void beforeFilter(Invoker invoker, InvokerData info) {
        Produces pro;
        if (!(invoker instanceof RenderInvoker)) {
            return;
        }
        RenderInvoker render = (RenderInvoker)invoker;
        Method targetMethod = info.targetMethod();
        if (targetMethod != null && targetMethod.isAnnotationPresent(Produces.class) && (pro = targetMethod.getAnnotation(Produces.class)) != null && !StringUtils.isBlank((String)pro.value())) {
            String proValue = pro.value();
            render.viewType(proValue);
            this.configContentType(render, proValue);
            render.lockViewType();
        }
    }

    private void configContentType(RenderInvoker renderInvoker, String type) {
        if (StringUtils.isBlank((String)type)) {
            return;
        }
        HttpServletResponse httpResponse = renderInvoker.getHttpResponse();
        String oriMimeType = httpResponse.getContentType();
        String newMimeType = renderInvoker.getMimeType(type);
        if (StringUtils.isNotBlank((String)newMimeType) && !StringUtils.equalsIgnoreCase((String)oriMimeType, (String)newMimeType)) {
            httpResponse.setContentType(newMimeType);
        }
    }

    @Override
    public Object doInvoke(Invoker invoker, InvokerChain chain) throws Throwable {
        Object returnData = chain.doNext(invoker);
        if (invoker instanceof RenderInvoker) {
            boolean process = this.process((RenderInvoker)invoker);
            if (process) {
                return returnData;
            }
            RenderInvoker renderInvoker = (RenderInvoker)invoker;
            HttpServletRequest httpRequest = renderInvoker.getHttpRequest();
            HttpServletResponse httpResponse = renderInvoker.getHttpResponse();
            if (!httpResponse.isCommitted()) {
                this.configContentType(renderInvoker, renderInvoker.viewType());
                httpRequest.getRequestDispatcher(renderInvoker.renderTo()).forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
        }
        return returnData;
    }

    @Override
    public void afterFilter(Invoker invoker, InvokerData info) {
    }

    public boolean process(RenderInvoker render) throws Throwable {
        if (render == null) {
            return false;
        }
        String engineType = render.viewType();
        RenderEngine engine = this.engineMap.get(engineType);
        if (engine == null) {
            return false;
        }
        if (render.getHttpResponse().isCommitted()) {
            return false;
        }
        String oriViewName = render.renderTo();
        String newViewName = render.renderTo();
        if (this.useLayout) {
            newViewName = this.templatePath + (oriViewName.charAt(0) != '/' ? "/" : "") + oriViewName;
        }
        String layoutFile = null;
        if (this.useLayout && render.layout()) {
            layoutFile = this.findLayout(engine, oriViewName);
        }
        if (layoutFile != null) {
            StringWriter tmpWriter = new StringWriter();
            if (!engine.exist(newViewName)) {
                return false;
            }
            render.renderTo(newViewName);
            engine.process(render, tmpWriter);
            render.put(this.placeholder, tmpWriter.toString());
            if (engine.exist(layoutFile)) {
                render.renderTo(layoutFile);
                this.configContentType(render, engineType);
                engine.process(render, render.getHttpResponse().getWriter());
                return true;
            }
            throw new IOException("layout '" + layoutFile + "' file is missing.");
        }
        if (engine.exist(newViewName)) {
            render.renderTo(newViewName);
            this.configContentType(render, engineType);
            engine.process(render, render.getHttpResponse().getWriter());
            return true;
        }
        return false;
    }

    protected String findLayout(RenderEngine engine, String tempFile) throws IOException {
        if (engine == null) {
            return null;
        }
        File layoutFile = new File(this.layoutPath, tempFile);
        if (engine.exist(layoutFile.getPath())) {
            return layoutFile.getPath();
        }
        if (engine.exist((layoutFile = new File(layoutFile.getParent(), this.defaultLayout)).getPath())) {
            return layoutFile.getPath();
        }
        while (layoutFile.getPath().startsWith(this.layoutPath)) {
            if (!engine.exist((layoutFile = new File(layoutFile.getParentFile().getParent(), this.defaultLayout)).getPath())) continue;
            return layoutFile.getPath();
        }
        return null;
    }
}

