/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.mime;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.hasor.utils.ResourcesUtils;
import net.hasor.utils.StringUtils;
import net.hasor.utils.io.IOUtils;
import net.hasor.web.MimeType;
import net.hasor.web.mime.SaxXmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class MimeTypeSupplier
extends ConcurrentHashMap<String, String>
implements MimeType {
    private static final long serialVersionUID = -8955832291109288048L;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private ServletContext content;

    public MimeTypeSupplier(ServletContext content) {
        this.content = content;
    }

    public ServletContext getContent() {
        return this.content;
    }

    @Override
    public String getMimeType(String suffix) {
        String mimeType = this.getContent().getMimeType(suffix);
        if (StringUtils.isNotBlank((String)mimeType)) {
            return mimeType;
        }
        return (String)this.get(suffix.toUpperCase());
    }

    public void addMimeType(String type, String mimeType) {
        if (StringUtils.isNotBlank((String)type) && StringUtils.isNotBlank((String)mimeType)) {
            this.put(type.toUpperCase(), mimeType);
        }
    }

    public void loadResource(String resourceName) throws IOException {
        List inStreamList = ResourcesUtils.getResourcesAsStream((String)resourceName);
        for (InputStream inStream : inStreamList) {
            this.loadStream(inStream);
        }
    }

    public void loadReader(Reader reader) throws IOException {
        this.logger.debug("parsingReader...");
        this.prossParser(reader, saxParser -> saxParser.parse(new InputSource(reader), (DefaultHandler)new SaxXmlParser(this)));
    }

    public void loadStream(InputStream inStream) throws IOException {
        this.logger.debug("parsingStream...");
        this.prossParser(inStream, saxParser -> saxParser.parse(inStream, (DefaultHandler)new SaxXmlParser(this)));
    }

    private void prossParser(Closeable closeable, Call call) throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            factory.setFeature("http://xml.org/sax/features/namespaces", true);
            call.parser(factory.newSAXParser());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)closeable);
        }
    }

    private static interface Call {
        public void parser(SAXParser var1) throws Exception;
    }
}

