/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.invoker;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpSessionListener;
import net.hasor.core.ApiBinder;
import net.hasor.core.AppContextAware;
import net.hasor.core.BindInfo;
import net.hasor.core.Environment;
import net.hasor.core.Hasor;
import net.hasor.core.binder.ApiBinderWrap;
import net.hasor.core.exts.aop.Matchers;
import net.hasor.core.provider.InstanceProvider;
import net.hasor.utils.StringUtils;
import net.hasor.web.InvokerFilter;
import net.hasor.web.MappingDiscoverer;
import net.hasor.web.RenderEngine;
import net.hasor.web.ServletVersion;
import net.hasor.web.WebApiBinder;
import net.hasor.web.WebPlugin;
import net.hasor.web.annotation.MappingTo;
import net.hasor.web.annotation.Render;
import net.hasor.web.definition.AbstractDefinition;
import net.hasor.web.definition.ContextListenerDefinition;
import net.hasor.web.definition.FilterDefinition;
import net.hasor.web.definition.HttpSessionListenerDefinition;
import net.hasor.web.definition.InvokeFilterDefinition;
import net.hasor.web.definition.MappingDiscovererDefinition;
import net.hasor.web.definition.RenderDefinition;
import net.hasor.web.definition.UriPatternMatcher;
import net.hasor.web.definition.UriPatternType;
import net.hasor.web.definition.WebPluginDefinition;
import net.hasor.web.invoker.InMappingDef;
import net.hasor.web.invoker.InMappingServlet;
import net.hasor.web.mime.MimeTypeSupplier;

public class InvokerWebApiBinder
extends ApiBinderWrap
implements WebApiBinder {
    private final InstanceProvider<String> requestEncoding = new InstanceProvider((Object)"");
    private final InstanceProvider<String> responseEncoding = new InstanceProvider((Object)"");
    private ServletVersion curVersion;
    private MimeTypeSupplier mimeType;

    protected InvokerWebApiBinder(ServletVersion curVersion, MimeTypeSupplier mimeType, ApiBinder apiBinder) {
        super(apiBinder);
        apiBinder.bindType(String.class).nameWith("HTTP_REQUEST_ENCODING").toProvider(this.requestEncoding);
        apiBinder.bindType(String.class).nameWith("HTTP_RESPONSE_ENCODING").toProvider(this.responseEncoding);
        this.curVersion = (ServletVersion)((Object)Hasor.assertIsNotNull((Object)((Object)curVersion)));
        this.mimeType = (MimeTypeSupplier)Hasor.assertIsNotNull((Object)mimeType);
    }

    @Override
    public ServletContext getServletContext() {
        return (ServletContext)this.getEnvironment().getContext();
    }

    @Override
    public WebApiBinder setRequestCharacter(String encoding) {
        this.requestEncoding.set((Object)encoding);
        return this;
    }

    @Override
    public WebApiBinder setResponseCharacter(String encoding) {
        this.responseEncoding.set((Object)encoding);
        return this;
    }

    @Override
    public String getMimeType(String suffix) {
        return this.mimeType.getMimeType(suffix);
    }

    @Override
    public void addMimeType(String type, String mimeType) {
        this.mimeType.addMimeType(type, mimeType);
    }

    @Override
    public void loadMimeType(Reader reader) throws IOException {
        this.mimeType.loadReader(reader);
    }

    @Override
    public ServletVersion getServletVersion() {
        return this.curVersion;
    }

    @Override
    public void addPlugin(BindInfo<? extends WebPlugin> webPlugin) {
        Hasor.assertIsNotNull(webPlugin);
        this.bindType(WebPluginDefinition.class).toInstance((Object)new WebPluginDefinition(webPlugin));
    }

    @Override
    public void addDiscoverer(BindInfo<? extends MappingDiscoverer> discoverer) {
        Hasor.assertIsNotNull(discoverer);
        MappingDiscovererDefinition definition = (MappingDiscovererDefinition)Hasor.autoAware((Environment)this.getEnvironment(), (AppContextAware)new MappingDiscovererDefinition(discoverer));
        this.bindType(MappingDiscovererDefinition.class).toInstance((Object)definition);
    }

    @Override
    public void addServletListener(BindInfo<? extends ServletContextListener> targetRegister) {
        this.bindType(ContextListenerDefinition.class).uniqueName().toInstance((Object)new ContextListenerDefinition(targetRegister));
    }

    @Override
    public void addSessionListener(BindInfo<? extends HttpSessionListener> targetRegister) {
        this.bindType(HttpSessionListenerDefinition.class).uniqueName().toInstance((Object)new HttpSessionListenerDefinition(targetRegister));
    }

    @Override
    public WebApiBinder.FilterBindingBuilder<InvokerFilter> filter(String[] morePatterns) {
        List<String> uriPatterns = InvokerWebApiBinder.checkEmpty(Arrays.asList(morePatterns), "Filter patterns is empty.");
        return new FiltersModuleBinder<InvokerFilter>(InvokerFilter.class, UriPatternType.SERVLET, uriPatterns){

            @Override
            protected void bindThrough(int index, String pattern, UriPatternMatcher matcher, BindInfo<? extends InvokerFilter> filterRegister, Map<String, String> initParams) {
                InvokerWebApiBinder.this.filterThrough(index, pattern, matcher, filterRegister, initParams);
            }
        };
    }

    @Override
    public WebApiBinder.FilterBindingBuilder<InvokerFilter> filterRegex(String[] regexes) {
        List<String> uriPatterns = InvokerWebApiBinder.checkEmpty(Arrays.asList(regexes), "Filter patterns is empty.");
        return new FiltersModuleBinder<InvokerFilter>(InvokerFilter.class, UriPatternType.REGEX, uriPatterns){

            @Override
            protected void bindThrough(int index, String pattern, UriPatternMatcher matcher, BindInfo<? extends InvokerFilter> filterRegister, Map<String, String> initParams) {
                InvokerWebApiBinder.this.filterThrough(index, pattern, matcher, filterRegister, initParams);
            }
        };
    }

    protected void filterThrough(int index, String pattern, UriPatternMatcher matcher, BindInfo<? extends InvokerFilter> filterRegister, Map<String, String> initParams) {
        InvokeFilterDefinition define = new InvokeFilterDefinition(index, pattern, matcher, filterRegister, initParams);
        this.bindType(AbstractDefinition.class).uniqueName().toInstance((Object)define);
        this.bindToCreater(filterRegister, define);
    }

    @Override
    public WebApiBinder.FilterBindingBuilder<Filter> jeeFilter(String[] morePatterns) throws NullPointerException {
        List<String> uriPatterns = InvokerWebApiBinder.checkEmpty(Arrays.asList(morePatterns), "Filter patterns is empty.");
        return new FiltersModuleBinder<Filter>(Filter.class, UriPatternType.SERVLET, uriPatterns){

            @Override
            protected void bindThrough(int index, String pattern, UriPatternMatcher matcher, BindInfo<? extends Filter> filterRegister, Map<String, String> initParams) {
                InvokerWebApiBinder.this.jeeFilterThrough(index, pattern, matcher, filterRegister, initParams);
            }
        };
    }

    @Override
    public WebApiBinder.FilterBindingBuilder<Filter> jeeFilterRegex(String[] regexes) throws NullPointerException {
        List<String> uriPatterns = InvokerWebApiBinder.checkEmpty(Arrays.asList(regexes), "Filter patterns is empty.");
        return new FiltersModuleBinder<Filter>(Filter.class, UriPatternType.REGEX, uriPatterns){

            @Override
            protected void bindThrough(int index, String pattern, UriPatternMatcher matcher, BindInfo<? extends Filter> filterRegister, Map<String, String> initParams) {
                InvokerWebApiBinder.this.jeeFilterThrough(index, pattern, matcher, filterRegister, initParams);
            }
        };
    }

    protected void jeeFilterThrough(int index, String pattern, UriPatternMatcher matcher, BindInfo<? extends Filter> filterRegister, Map<String, String> initParams) {
        FilterDefinition define = new FilterDefinition(index, pattern, matcher, filterRegister, initParams);
        this.bindType(AbstractDefinition.class).uniqueName().toInstance((Object)define);
        this.bindToCreater(filterRegister, define);
    }

    protected void jeeServlet(int index, String pattern, BindInfo<? extends HttpServlet> servletRegister, Map<String, String> initParams) {
        InMappingServlet define = new InMappingServlet(index, servletRegister, pattern, initParams, this.getServletContext());
        this.bindType(InMappingDef.class).uniqueName().toInstance((Object)define);
        this.bindToCreater(servletRegister, define);
    }

    @Override
    public WebApiBinder.ServletBindingBuilder jeeServlet(String[] morePatterns) {
        return new ServletsModuleBuilder(InvokerWebApiBinder.checkEmpty(Arrays.asList(morePatterns), "Servlet patterns is empty."));
    }

    @Override
    public <T> WebApiBinder.MappingToBindingBuilder<T> mappingTo(final String[] morePatterns) {
        InvokerWebApiBinder.checkEmpty(Arrays.asList(morePatterns), "mappingTo patterns is empty.");
        return new WebApiBinder.MappingToBindingBuilder<T>(){

            @Override
            public void with(int index, Class<? extends T> targetKey) {
                this.with(index, InvokerWebApiBinder.this.bindType(targetKey).uniqueName().toInfo());
            }

            @Override
            public void with(int index, T target) {
                Class<?> targetType = target.getClass();
                this.with(index, InvokerWebApiBinder.this.bindType(targetType).uniqueName().toInstance(target).toInfo());
            }

            @Override
            public void with(int index, Class<T> referKey, Supplier<? extends T> targetProvider) {
                this.with(index, InvokerWebApiBinder.this.bindType(referKey).uniqueName().toProvider(targetProvider).toInfo());
            }

            @Override
            public void with(int index, BindInfo<? extends T> targetInfo) {
                Arrays.stream(morePatterns).filter(StringUtils::isNotBlank).forEach(pattern -> {
                    InMappingDef define = new InMappingDef(index, targetInfo, (String)pattern, Matchers.anyMethod(), true);
                    InvokerWebApiBinder.this.bindType(InMappingDef.class).uniqueName().toInstance((Object)define);
                });
            }
        };
    }

    @Override
    public void loadMappingTo(Class<?> mabeMappingType) {
        Hasor.assertIsNotNull(mabeMappingType, (String)"class is null.");
        int modifier = mabeMappingType.getModifiers();
        if (this.checkIn(modifier, 512) || this.checkIn(modifier, 1024) || mabeMappingType.isArray() || mabeMappingType.isEnum()) {
            throw new IllegalStateException(mabeMappingType.getName() + " must be normal Bean");
        }
        MappingTo[] annotationsByType = (MappingTo[])mabeMappingType.getAnnotationsByType(MappingTo.class);
        if (annotationsByType == null || annotationsByType.length == 0) {
            throw new IllegalStateException(mabeMappingType.getName() + " must be configure @MappingTo");
        }
        if (HttpServlet.class.isAssignableFrom(mabeMappingType)) {
            Arrays.stream(annotationsByType).peek(mappingTo -> logger.info("mapingTo[Servlet] -> type \u2018{}\u2019 mappingTo: \u2018{}\u2019.", (Object)mabeMappingType.getName(), (Object)mappingTo.value())).forEach(mappingTo -> this.jeeServlet(mappingTo.value()).with(mabeMappingType));
        } else {
            Arrays.stream(annotationsByType).peek(mappingTo -> logger.info("mapingTo[Object] -> type \u2018{}\u2019 mappingTo: \u2018{}\u2019.", (Object)mabeMappingType.getName(), (Object)mappingTo.value())).forEach(mappingTo -> this.mappingTo(mappingTo.value()).with(mabeMappingType));
        }
    }

    @Override
    public void loadRender(Class<?> renderClass) {
        Hasor.assertIsNotNull(renderClass, (String)"class is null.");
        int modifier = renderClass.getModifiers();
        if (this.checkIn(modifier, 512) || this.checkIn(modifier, 1024) || renderClass.isArray() || renderClass.isEnum()) {
            throw new IllegalStateException(renderClass.getName() + " must be normal Bean");
        }
        if (!renderClass.isAnnotationPresent(Render.class)) {
            throw new IllegalStateException(renderClass.getName() + " must be configure @Render");
        }
        if (!RenderEngine.class.isAssignableFrom(renderClass)) {
            throw new IllegalStateException(renderClass.getName() + " must be implements RenderEngine.");
        }
        Render renderInfo = renderClass.getAnnotation(Render.class);
        if (renderInfo != null && renderInfo.value().length > 0) {
            String[] renderName = renderInfo.value();
            InvokerWebApiBinder.checkEmpty(Arrays.asList(renderName), "Render patterns is empty.");
            this.suffix(renderInfo.value()).bind(renderClass);
        }
    }

    @Override
    public WebApiBinder.RenderEngineBindingBuilder suffix(String[] suffixArrays) {
        return new RenderEngineBindingBuilderImpl((List)InvokerWebApiBinder.checkEmpty(Arrays.asList(suffixArrays), "Render patterns is empty.")){

            @Override
            protected void bindSuffix(List<String> suffixList, BindInfo<? extends RenderEngine> bindInfo) {
                if (suffixList == null || suffixList.isEmpty()) {
                    return;
                }
                suffixList = Collections.unmodifiableList(suffixList);
                InvokerWebApiBinder.this.bindType(RenderDefinition.class).toInstance((Object)new RenderDefinition(suffixList, bindInfo)).toInfo();
            }
        };
    }

    private boolean checkIn(int data, int check) {
        int or = data | check;
        return or == data;
    }

    private static List<String> checkEmpty(List<String> patternArrays, String npeMessage) {
        boolean needThrow = true;
        for (String pattern : patternArrays) {
            if (StringUtils.isBlank((String)pattern)) continue;
            needThrow = false;
            break;
        }
        if (needThrow) {
            throw new NullPointerException(npeMessage);
        }
        return patternArrays;
    }

    private abstract class RenderEngineBindingBuilderImpl
    implements WebApiBinder.RenderEngineBindingBuilder {
        private List<String> suffixList;

        public RenderEngineBindingBuilderImpl(List<String> suffixList) {
            this.suffixList = suffixList.stream().filter(StringUtils::isNotBlank).map(String::toUpperCase).distinct().collect(Collectors.toList());
        }

        @Override
        public <T extends RenderEngine> void bind(Class<T> renderEngineType) {
            this.bindSuffix(this.suffixList, (BindInfo<? extends RenderEngine>)InvokerWebApiBinder.this.bindType(RenderEngine.class).uniqueName().to(renderEngineType).toInfo());
        }

        @Override
        public void bind(Supplier<? extends RenderEngine> renderEngineProvider) {
            this.bindSuffix(this.suffixList, (BindInfo<? extends RenderEngine>)InvokerWebApiBinder.this.bindType(RenderEngine.class).uniqueName().toProvider(renderEngineProvider).toInfo());
        }

        @Override
        public void bind(BindInfo<? extends RenderEngine> renderEngineInfo) {
            this.bindSuffix(this.suffixList, (BindInfo<? extends RenderEngine>)((BindInfo)Hasor.assertIsNotNull(renderEngineInfo)));
        }

        protected abstract void bindSuffix(List<String> var1, BindInfo<? extends RenderEngine> var2);
    }

    private class ServletsModuleBuilder
    implements WebApiBinder.ServletBindingBuilder {
        private List<String> uriPatterns;

        ServletsModuleBuilder(List<String> uriPatterns) {
            this.uriPatterns = uriPatterns;
        }

        @Override
        public void with(int index, Class<? extends HttpServlet> servletKey, Map<String, String> initParams) {
            BindInfo servletRegister = InvokerWebApiBinder.this.bindType(HttpServlet.class).uniqueName().to(servletKey).toInfo();
            this.with(index, (BindInfo<? extends HttpServlet>)servletRegister, initParams);
        }

        @Override
        public void with(int index, HttpServlet servlet, Map<String, String> initParams) {
            BindInfo servletRegister = InvokerWebApiBinder.this.bindType(HttpServlet.class).uniqueName().toInstance((Object)servlet).toInfo();
            this.with(index, (BindInfo<? extends HttpServlet>)servletRegister, initParams);
        }

        @Override
        public void with(int index, Supplier<? extends HttpServlet> servletProvider, Map<String, String> initParams) {
            BindInfo servletRegister = InvokerWebApiBinder.this.bindType(HttpServlet.class).uniqueName().toProvider(servletProvider).toInfo();
            this.with(index, (BindInfo<? extends HttpServlet>)servletRegister, initParams);
        }

        @Override
        public void with(int index, BindInfo<? extends HttpServlet> servletRegister, Map<String, String> initParams) {
            if (initParams == null) {
                initParams = new HashMap<String, String>();
            }
            for (String pattern : this.uriPatterns) {
                InvokerWebApiBinder.this.jeeServlet(index, pattern, servletRegister, initParams);
            }
        }
    }

    private abstract class FiltersModuleBinder<T>
    implements WebApiBinder.FilterBindingBuilder<T> {
        private final Class<T> targetType;
        private final UriPatternType uriPatternType;
        private final List<String> uriPatterns;

        FiltersModuleBinder(Class<T> targetType, UriPatternType uriPatternType, List<String> uriPatterns) {
            this.targetType = targetType;
            this.uriPatternType = uriPatternType;
            this.uriPatterns = uriPatterns;
        }

        @Override
        public void through(int index, Class<? extends T> filterKey, Map<String, String> initParams) {
            BindInfo filterRegister = InvokerWebApiBinder.this.bindType(this.targetType).uniqueName().to(filterKey).toInfo();
            this.through(index, filterRegister, initParams);
        }

        @Override
        public void through(int index, T filter, Map<String, String> initParams) {
            BindInfo filterRegister = InvokerWebApiBinder.this.bindType(this.targetType).uniqueName().toInstance(filter).toInfo();
            this.through(index, filterRegister, initParams);
        }

        @Override
        public void through(int index, Supplier<? extends T> filterProvider, Map<String, String> initParams) {
            BindInfo filterRegister = InvokerWebApiBinder.this.bindType(this.targetType).uniqueName().toProvider(filterProvider).toInfo();
            this.through(index, filterRegister, initParams);
        }

        @Override
        public void through(int index, BindInfo<? extends T> filterRegister, Map<String, String> initParams) {
            if (initParams == null) {
                initParams = new HashMap<String, String>();
            }
            for (String pattern : this.uriPatterns) {
                UriPatternMatcher matcher = UriPatternType.get(this.uriPatternType, pattern);
                this.bindThrough(index, pattern, matcher, filterRegister, initParams);
            }
        }

        protected abstract void bindThrough(int var1, String var2, UriPatternMatcher var3, BindInfo<? extends T> var4, Map<String, String> var5);
    }
}

