/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.invoker;

import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.AppContext;
import net.hasor.core.Hasor;
import net.hasor.utils.Iterators;
import net.hasor.utils.future.BasicFuture;
import net.hasor.web.Invoker;
import net.hasor.web.InvokerConfig;
import net.hasor.web.InvokerData;
import net.hasor.web.MappingDiscoverer;
import net.hasor.web.WebPlugin;
import net.hasor.web.definition.AbstractDefinition;
import net.hasor.web.definition.WebPluginDefinition;
import net.hasor.web.invoker.ExceuteCaller;
import net.hasor.web.invoker.InMapping;
import net.hasor.web.invoker.InMappingDef;
import net.hasor.web.invoker.InvokerCaller;
import net.hasor.web.invoker.InvokerChainInvocation;
import net.hasor.web.invoker.InvokerSupplier;
import net.hasor.web.invoker.RootInvokerCreater;
import net.hasor.web.invoker.WebPluginCaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokerContext
implements WebPluginCaller {
    protected static Logger logger = LoggerFactory.getLogger(InvokerContext.class);
    private AppContext appContext = null;
    private InMapping[] invokeArray = new InMapping[0];
    private AbstractDefinition[] filters = new AbstractDefinition[0];
    private WebPlugin[] plugins = new WebPlugin[0];
    private RootInvokerCreater invokerCreater = null;

    public void initContext(final AppContext appContext, Map<String, String> configMap) throws Throwable {
        this.appContext = (AppContext)Hasor.assertIsNotNull((Object)appContext);
        List mappingList = appContext.findBindingBean(InMappingDef.class);
        mappingList.sort(Comparator.comparingLong(InMappingDef::getIndex));
        for (InMapping inMapping : this.invokeArray = mappingList.toArray(new InMapping[0])) {
            logger.info("mapingTo -> type \u2018{}\u2019 mappingTo: \u2018{}\u2019.", (Object)inMapping.getTargetType().getBindType(), (Object)inMapping.getMappingTo());
        }
        List pluginList = appContext.findBindingBean(WebPluginDefinition.class);
        this.plugins = pluginList.toArray(new WebPlugin[0]);
        for (WebPluginDefinition plugin : pluginList) {
            plugin.initPlugin(appContext);
            logger.info("webPlugin -> type \u2018{}\u2019.", (Object)plugin.toString());
        }
        List setupList = appContext.findBindingBean(MappingDiscoverer.class);
        for (MappingDiscoverer setup : setupList) {
            for (InMapping mapping : this.invokeArray) {
                setup.discover(mapping);
            }
        }
        final Map<String, String> config = Collections.unmodifiableMap(new HashMap<String, String>(configMap));
        InvokerConfig filterConfig = new InvokerConfig(){

            @Override
            public String getInitParameter(String name) {
                return (String)config.get(name);
            }

            @Override
            public Enumeration<String> getInitParameterNames() {
                return Iterators.asEnumeration(config.keySet().iterator());
            }

            @Override
            public AppContext getAppContext() {
                return appContext;
            }
        };
        this.filters = (AbstractDefinition[])appContext.findBindingBean(AbstractDefinition.class).stream().sorted(Comparator.comparingLong(AbstractDefinition::getIndex)).toArray(AbstractDefinition[]::new);
        for (AbstractDefinition filter : this.filters) {
            filter.init(filterConfig);
        }
        this.invokerCreater = new RootInvokerCreater(appContext);
    }

    public void destroyContext() {
        for (AbstractDefinition filter : this.filters) {
            filter.destroy();
        }
    }

    public Invoker newInvoker(HttpServletRequest request, HttpServletResponse response) {
        return this.invokerCreater.createExt(new InvokerSupplier(this.appContext, request, response));
    }

    public ExceuteCaller genCaller(Invoker invoker) {
        InMapping foundDefine = null;
        for (InMapping define : this.invokeArray) {
            if (!define.matchingMapping(invoker)) continue;
            foundDefine = define;
            break;
        }
        if (foundDefine == null) {
            return (invoker1, chain) -> {
                BasicFuture future = new BasicFuture();
                future.completed(new InvokerChainInvocation(this.filters, invoker11 -> {
                    if (chain != null) {
                        chain.doFilter((ServletRequest)invoker11.getHttpRequest(), (ServletResponse)invoker11.getHttpResponse());
                    }
                    return invoker11.get("resultData");
                }).doNext(invoker1));
                return future;
            };
        }
        return new InvokerCaller(foundDefine, this.filters, this);
    }

    @Override
    public void beforeFilter(Invoker invoker, InvokerData define) {
        for (WebPlugin plugin : this.plugins) {
            plugin.beforeFilter(invoker, define);
        }
    }

    @Override
    public void afterFilter(Invoker invoker, InvokerData define) {
        for (WebPlugin plugin : this.plugins) {
            plugin.afterFilter(invoker, define);
        }
    }
}

