/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.invoker;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.hasor.core.BindInfo;
import net.hasor.core.Hasor;
import net.hasor.utils.BeanUtils;
import net.hasor.utils.StringUtils;
import net.hasor.web.Invoker;
import net.hasor.web.annotation.Async;
import net.hasor.web.annotation.HttpMethod;
import net.hasor.web.invoker.AsyncSupported;
import net.hasor.web.invoker.InMapping;

public class InMappingDef
implements InMapping {
    private final int index;
    private BindInfo<?> targetType;
    private String mappingTo;
    private String mappingToMatches;
    private Map<String, Method> httpMapping;
    private Set<Method> asyncMethod;
    private AsyncSupported defaultAsync = AsyncSupported.no;

    public InMappingDef(int index, BindInfo<?> targetType, String mappingTo, Predicate<Method> methodMatcher) {
        this(index, targetType, mappingTo, methodMatcher, true);
    }

    public InMappingDef(int index, BindInfo<?> targetType, String mappingTo, Predicate<Method> methodMatcher, boolean needAnno) {
        this.targetType = (BindInfo)Hasor.assertIsNotNull(targetType, (String)"targetType is null.");
        if (StringUtils.isBlank((String)mappingTo)) {
            throw new NullPointerException("'" + targetType.getBindType() + "' Service path is empty.");
        }
        if (!mappingTo.matches("/.+")) {
            throw new IllegalStateException("'" + targetType.getBindType() + "' Service path format error, must be a '/' at the start.");
        }
        if (targetType.getBindType().getAnnotation(Async.class) != null) {
            this.defaultAsync = AsyncSupported.yes;
        }
        this.index = index;
        this.mappingTo = mappingTo;
        this.mappingToMatches = InMappingDef.wildToRegex(mappingTo).replaceAll("\\{\\w{1,}\\}", "([^/]{1,})");
        this.httpMapping = new HashMap<String, Method>();
        this.asyncMethod = new HashSet<Method>();
        List methodList = BeanUtils.getMethods((Class)targetType.getBindType());
        for (Method targetMethod : methodList) {
            boolean matches = methodMatcher.test(targetMethod);
            if (!matches) continue;
            Annotation[] annos = targetMethod.getAnnotations();
            if (annos != null) {
                for (Annotation anno : annos) {
                    String[] methodSet;
                    HttpMethod httpMethodAnno;
                    if (anno instanceof HttpMethod) {
                        String[] methodSet2;
                        for (String http : methodSet2 = ((HttpMethod)anno).value()) {
                            this.httpMapping.put(http.toUpperCase(), targetMethod);
                        }
                    }
                    if ((httpMethodAnno = anno.annotationType().getAnnotation(HttpMethod.class)) == null) continue;
                    for (String http : methodSet = httpMethodAnno.value()) {
                        this.httpMapping.put(http.toUpperCase(), targetMethod);
                    }
                }
            }
            if (this.httpMapping.isEmpty() && !needAnno) {
                this.httpMapping.put("ANY", targetMethod);
            }
            if (targetMethod.getAnnotation(Async.class) == null) continue;
            this.asyncMethod.add(targetMethod);
        }
    }

    private static String wildToRegex(String wild) {
        wild = wild.replace("\\", "\\\\");
        wild = wild.replace("$", "\\$");
        wild = wild.replace("^", "\\^");
        wild = wild.replace("[", "\\[");
        wild = wild.replace("]", "\\]");
        wild = wild.replace("(", "\\(");
        wild = wild.replace(")", "\\)");
        wild = wild.replace("|", "\\|");
        wild = wild.replace("+", "\\+");
        wild = wild.replace(".", "\\.");
        wild = wild.replace("*", ".*");
        wild = wild.replace("?", ".");
        return wild;
    }

    @Override
    public BindInfo<?> getTargetType() {
        return this.targetType;
    }

    @Override
    public String getMappingTo() {
        return this.mappingTo;
    }

    @Override
    public String getMappingToMatches() {
        return this.mappingToMatches;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String[] getHttpMethodSet() {
        return this.httpMapping.keySet().toArray(new String[this.httpMapping.size()]);
    }

    @Override
    public Method getHttpMethod(String httpMethod) {
        return this.httpMapping.get(httpMethod);
    }

    @Override
    public boolean matchingMapping(Invoker invoker) {
        String httpMethod = invoker.getHttpRequest().getMethod();
        String requestPath = invoker.getRequestPath();
        Hasor.assertIsNotNull((Object)requestPath, (String)"requestPath is null.");
        if (!requestPath.matches(this.mappingToMatches)) {
            return false;
        }
        for (String m : this.httpMapping.keySet()) {
            if (httpMethod.equalsIgnoreCase(m)) {
                return true;
            }
            if (!"ANY".equalsIgnoreCase(m)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Method findMethod(Invoker invoker) {
        String requestPath = invoker.getRequestPath();
        Hasor.assertIsNotNull((Object)requestPath, (String)"requestPath is null.");
        if (!requestPath.matches(this.mappingToMatches)) {
            return null;
        }
        String httpMethod = invoker.getHttpRequest().getMethod();
        Method targetMethod = this.httpMapping.get(httpMethod.trim().toUpperCase());
        if (targetMethod == null) {
            targetMethod = this.httpMapping.get("ANY");
        }
        return targetMethod;
    }

    @Override
    public boolean isAsync(Invoker invoker) {
        Method targetMethod = this.findMethod(invoker);
        if (targetMethod == null) {
            return false;
        }
        AsyncSupported async = this.asyncMethod.contains(targetMethod) ? AsyncSupported.yes : this.defaultAsync;
        return AsyncSupported.yes == async;
    }

    @Override
    public Object newInstance(Invoker invoker) throws Throwable {
        return invoker.getAppContext().getInstance(this.getTargetType());
    }

    public String toString() {
        return String.format("pattern=%s ,methodSet=%s ,type %s", this.mappingTo, StringUtils.join((Object[])this.httpMapping.keySet().toArray(), (String)","), this.getTargetType());
    }
}

