/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.definition;

import java.util.regex.Pattern;
import net.hasor.web.definition.UriPatternMatcher;

public enum UriPatternType {
    SERVLET,
    REGEX;


    public static UriPatternMatcher get(UriPatternType type, String pattern) {
        if (type == SERVLET) {
            return new ServletStyleUriPatternMatcher(pattern);
        }
        if (type == REGEX) {
            return new RegexUriPatternMatcher(pattern);
        }
        return null;
    }

    private static class RegexUriPatternMatcher
    implements UriPatternMatcher {
        private final Pattern pattern;

        public RegexUriPatternMatcher(String pattern) {
            this.pattern = Pattern.compile(pattern);
        }

        @Override
        public boolean matches(String uri) {
            return null != uri && this.pattern.matcher(uri).matches();
        }

        @Override
        public UriPatternType getPatternType() {
            return REGEX;
        }
    }

    private static class ServletStyleUriPatternMatcher
    implements UriPatternMatcher {
        private final String pattern;
        private final Kind patternKind;

        public ServletStyleUriPatternMatcher(String pattern) {
            if (pattern.startsWith("*")) {
                this.pattern = pattern.substring(1);
                this.patternKind = Kind.PREFIX;
            } else if (pattern.endsWith("*")) {
                this.pattern = pattern.substring(0, pattern.length() - 1);
                this.patternKind = Kind.SUFFIX;
            } else if (pattern.startsWith("/")) {
                this.pattern = pattern;
                this.patternKind = Kind.WITHROOT;
            } else {
                this.pattern = pattern;
                this.patternKind = Kind.LITERAL;
            }
        }

        @Override
        public boolean matches(String uri) {
            if (null == uri) {
                return false;
            }
            if (this.patternKind == Kind.PREFIX) {
                return uri.endsWith(this.pattern);
            }
            if (this.patternKind == Kind.SUFFIX) {
                return uri.startsWith(this.pattern);
            }
            if (this.patternKind == Kind.WITHROOT) {
                return this.pattern.equals(uri);
            }
            return this.pattern.equals(uri.substring(1));
        }

        @Override
        public UriPatternType getPatternType() {
            return SERVLET;
        }

        private static enum Kind {
            PREFIX,
            SUFFIX,
            LITERAL,
            WITHROOT;

        }
    }
}

