/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.valid;

import java.io.Serializable;
import net.hasor.web.valid.MessageTemplate;
import net.hasor.web.valid.MessageTemplateString;

public class Message
implements Serializable {
    private static final long serialVersionUID = -4678293554960623786L;
    private MessageTemplate messageTemplate = null;
    private Object[] messageParams = null;

    public Message(String message) {
        this(0, message, null);
    }

    public Message(int messageType, String messageTemplate, Object[] messageParams) {
        this(new MessageTemplateString(messageType, messageTemplate), messageParams);
    }

    public Message(MessageTemplate messageTemplate, Object[] messageParams) {
        this.messageTemplate = messageTemplate;
        this.messageParams = messageParams == null ? new Object[]{} : messageParams;
    }

    public MessageTemplate getMessageTemplate() {
        return this.messageTemplate;
    }

    public String getMessage() {
        String messageTemplate = this.messageTemplate.getMessageTemplate();
        try {
            if (this.messageParams != null && this.messageParams.length > 0) {
                return String.format(messageTemplate, this.messageParams);
            }
            return messageTemplate;
        }
        catch (Exception e) {
            return messageTemplate;
        }
    }

    public int getType() {
        return this.messageTemplate.getMessageType();
    }

    public Object[] getParameters() {
        return this.messageParams;
    }

    public String toString() {
        return this.getMessage();
    }
}

