/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.upload.factorys.disk;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import net.hasor.utils.IOUtils;
import net.hasor.web.FileItem;
import net.hasor.web.FileItemFactory;
import net.hasor.web.FileItemStream;
import net.hasor.web.upload.FileItemBase;
import net.hasor.web.upload.factorys.disk.DiskFileItem;

public class DiskFileItemFactory
implements FileItemFactory {
    private File cacheDirectory;

    public DiskFileItemFactory() {
    }

    public DiskFileItemFactory(String cacheDirectory) {
        this.cacheDirectory = new File(cacheDirectory);
    }

    public File getCacheDirectory() {
        return this.cacheDirectory;
    }

    public void setCacheDirectory(File cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    @Override
    public FileItem createItem(FileItemStream itemStream) throws IOException {
        String fid = UUID.randomUUID().toString() + ".tmp";
        if (itemStream.isFormField()) {
            return new MemoryFileItem(itemStream);
        }
        return this.createDiskFileItem(itemStream, fid);
    }

    protected FileItem createDiskFileItem(FileItemStream itemStream, String fid) throws IOException {
        return new DiskFileItem(itemStream, new File(this.cacheDirectory, fid));
    }

    public static class MemoryFileItem
    extends FileItemBase {
        private byte[] cachedContent;

        public MemoryFileItem(FileItemStream stream) throws IOException {
            super(stream);
            ByteArrayOutputStream arrays = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)stream.openStream(), (OutputStream)arrays);
            this.cachedContent = arrays.toByteArray();
        }

        @Override
        public long getSize() {
            if (this.cachedContent != null) {
                return this.cachedContent.length;
            }
            return 0L;
        }

        @Override
        public void deleteOrSkip() {
        }

        @Override
        public InputStream openStream() throws IOException {
            if (this.cachedContent == null) {
                return null;
            }
            return new ByteArrayInputStream(this.cachedContent);
        }
    }
}

