/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.upload;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.hasor.utils.IOUtils;
import net.hasor.web.FileItem;
import net.hasor.web.FileItemHeaders;
import net.hasor.web.FileItemStream;
import net.hasor.web.upload.util.Streams;

public abstract class FileItemBase
implements FileItem {
    private final FileItemHeaders headers;
    private final String contentType;
    private final String name;
    private final String fieldName;
    private final boolean formField;

    public FileItemBase(FileItemStream stream) {
        this.headers = stream.getHeaders();
        this.contentType = stream.getContentType();
        this.name = stream.getName();
        this.fieldName = stream.getFieldName();
        this.formField = stream.isFormField();
    }

    @Override
    public FileItemHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public boolean isFormField() {
        return this.formField;
    }

    @Override
    public byte[] get() throws IOException {
        InputStream inStream = this.openStream();
        if (inStream == null) {
            throw new IOException("openStream result is null.");
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)inStream, (OutputStream)outStream);
        IOUtils.closeQuietly((InputStream)inStream);
        return outStream.toByteArray();
    }

    @Override
    public String getString(String encoding) throws IOException {
        InputStream inStream = this.openStream();
        if (inStream == null) {
            throw new IOException("openStream result is null.");
        }
        String asString = Streams.asString(inStream, encoding);
        IOUtils.closeQuietly((InputStream)inStream);
        return asString;
    }

    @Override
    public String getString() throws IOException {
        InputStream inStream = this.openStream();
        if (inStream == null) {
            throw new IOException("openStream result is null.");
        }
        String asString = Streams.asString(inStream);
        IOUtils.closeQuietly((InputStream)inStream);
        return asString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(File outputFile) throws IOException {
        InputStream inStream = this.openStream();
        if (inStream == null) {
            throw new IOException("openStream result is null.");
        }
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            File parentFile = outputFile.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            in = new BufferedInputStream(inStream);
            out = new BufferedOutputStream(new FileOutputStream(outputFile));
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }

    @Override
    public void writeTo(OutputStream outStream) throws IOException {
        InputStream inStream = this.openStream();
        if (inStream == null) {
            throw new IOException("openStream result is null.");
        }
        IOUtils.copy((InputStream)inStream, (OutputStream)outStream);
        IOUtils.closeQuietly((InputStream)inStream);
    }
}

