/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.startup;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import net.hasor.core.AppContext;
import net.hasor.core.Hasor;
import net.hasor.core.Module;
import net.hasor.utils.ExceptionUtils;
import net.hasor.utils.StringUtils;
import net.hasor.web.listener.ListenerPipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeListener
implements ServletContextListener,
HttpSessionListener {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String AppContextName = AppContext.class.getName();
    private AppContext appContext = null;
    private ListenerPipeline listenerPipeline = null;

    protected Hasor createAppContext(ServletContext sc) throws Throwable {
        String webContextDir = sc.getRealPath("/");
        final class WebHasor
        extends Hasor {
            protected WebHasor(Object context) {
                super(context);
            }
        }
        return WebHasor.create((Object)sc).putFrameworkData("HASOR_WEBROOT", webContextDir);
    }

    protected Module getStartModule(ServletContext sc) throws Exception {
        Module startModule = null;
        String startModuleType = sc.getInitParameter("startModule");
        if (StringUtils.isBlank((String)startModuleType)) {
            this.logger.info("web initModule is undefinition.");
        } else {
            Class<?> startModuleClass = Thread.currentThread().getContextClassLoader().loadClass(startModuleType);
            startModule = (Module)startModuleClass.newInstance();
            this.logger.info("web initModule is " + startModuleType);
        }
        return startModule;
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            ServletContext sc = servletContextEvent.getServletContext();
            Module startModule = this.getStartModule(sc);
            this.appContext = this.createAppContext(sc).build(new Module[]{startModule});
        }
        catch (Throwable e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
        this.listenerPipeline = (ListenerPipeline)this.appContext.getInstance(ListenerPipeline.class);
        this.listenerPipeline.init(this.appContext);
        this.logger.info("sessionListenerPipeline created.");
        this.logger.info("ServletContext Attribut is " + AppContextName);
        servletContextEvent.getServletContext().setAttribute(AppContextName, (Object)this.appContext);
        this.listenerPipeline.contextInitialized(servletContextEvent);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        if (this.listenerPipeline != null) {
            this.listenerPipeline.contextDestroyed(servletContextEvent);
        }
        this.appContext.shutdown();
        this.logger.info("shutdown.");
    }

    public void sessionCreated(HttpSessionEvent se) {
        if (this.listenerPipeline != null) {
            this.listenerPipeline.sessionCreated(se);
        }
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        if (this.listenerPipeline != null) {
            this.listenerPipeline.sessionDestroyed(se);
        }
    }

    public static AppContext getAppContext(ServletContext servletContext) {
        return (AppContext)servletContext.getAttribute(AppContextName);
    }
}

