/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.render;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import net.hasor.utils.StringUtils;
import net.hasor.web.Invoker;
import net.hasor.web.RenderInvoker;
import net.hasor.web.wrap.InvokerWrap;

public class RenderInvokerSupplier
extends InvokerWrap
implements RenderInvoker {
    private String viewName = null;
    private String viewType = null;
    private boolean useLayout = true;

    protected RenderInvokerSupplier(Invoker invoker) {
        super(invoker);
        HttpServletRequest httpRequest = this.getHttpRequest();
        Enumeration paramEnum = httpRequest.getParameterNames();
        while (paramEnum.hasMoreElements()) {
            Object paramKey = paramEnum.nextElement();
            String key = paramKey.toString();
            String val = httpRequest.getParameter(key);
            httpRequest.setAttribute("req_" + key, (Object)val);
        }
        this.viewName = this.getRequestPath();
        int lastIndex = this.viewName.lastIndexOf(".");
        if (lastIndex > 0) {
            this.viewType(this.viewName.substring(lastIndex + 1));
        } else {
            this.viewType("default");
        }
    }

    @Override
    public String renderTo() {
        return this.viewName;
    }

    @Override
    public void renderTo(String viewName) {
        this.viewName = viewName;
    }

    @Override
    public void renderTo(String viewType, String viewName) {
        this.viewType(viewType);
        this.viewName = viewName;
    }

    @Override
    public String viewType() {
        return this.viewType;
    }

    @Override
    public void viewType(String viewType) {
        this.viewType = StringUtils.isNotBlank((String)viewType) ? viewType.trim().toUpperCase() : "";
    }

    @Override
    public boolean layout() {
        return this.useLayout;
    }

    @Override
    public void layoutEnable() {
        this.useLayout = true;
    }

    @Override
    public void layoutDisable() {
        this.useLayout = false;
    }
}

