/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.render;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.hasor.core.ApiBinder;
import net.hasor.core.BindInfo;
import net.hasor.core.Hasor;
import net.hasor.core.Matcher;
import net.hasor.core.Provider;
import net.hasor.core.binder.ApiBinderWrap;
import net.hasor.utils.ExceptionUtils;
import net.hasor.utils.StringUtils;
import net.hasor.web.RenderEngine;
import net.hasor.web.WebApiBinder;
import net.hasor.web.annotation.Render;
import net.hasor.web.invoker.InMappingDef;
import net.hasor.web.render.DefaultServlet;
import net.hasor.web.render.RenderDefinition;

public class RenderApiBinderImpl
extends ApiBinderWrap {
    private BindInfo<DefaultServlet> defaultServletBindInfo;

    protected RenderApiBinderImpl(ApiBinder apiBinder) {
        super(apiBinder);
        this.defaultServletBindInfo = apiBinder.bindType(DefaultServlet.class).toInfo();
    }

    public WebApiBinder.RenderEngineBindingBuilder<RenderEngine> suffix(String suffix, String ... moreSuffix) {
        return new RenderEngineBindingBuilderImpl(RenderApiBinderImpl.newArrayList(moreSuffix, suffix));
    }

    public WebApiBinder.RenderEngineBindingBuilder<RenderEngine> suffix(String[] suffixArrays) {
        return new RenderEngineBindingBuilderImpl(RenderApiBinderImpl.newArrayList(suffixArrays, null));
    }

    private void bindSuffix(List<String> suffixList, BindInfo<? extends RenderEngine> bindInfo) {
        suffixList = Collections.unmodifiableList(suffixList);
        this.bindType(RenderDefinition.class).toInstance((Object)new RenderDefinition(suffixList, bindInfo)).toInfo();
        Method serviceMethod = null;
        try {
            serviceMethod = DefaultServlet.class.getMethod("service", ServletRequest.class, ServletResponse.class);
        }
        catch (NoSuchMethodException e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
        for (String suffix : suffixList) {
            if (suffix.equals("*") || StringUtils.isBlank((String)suffix)) continue;
            String pattern = "/*." + suffix.toLowerCase();
            InMappingDef define = new InMappingDef(Long.MAX_VALUE, this.defaultServletBindInfo, pattern, Arrays.asList(serviceMethod), false);
            this.bindType(InMappingDef.class).uniqueName().toInstance((Object)define);
        }
    }

    public void scanAnnoRender(Matcher<Class<? extends RenderEngine>> matcher, String ... packages) {
        String[] defaultPackages = this.getEnvironment().getSpanPackage();
        String[] scanPackages = packages == null || packages.length == 0 ? defaultPackages : packages;
        Set renderSet = this.findClass(RenderEngine.class, scanPackages);
        for (Class renderClass : renderSet) {
            Render renderInfo;
            if (renderClass.isInterface() || renderClass == RenderEngine.class) continue;
            Class target = renderClass;
            if (matcher != null && !matcher.matches((Object)target) || (renderInfo = renderClass.getAnnotation(Render.class)) == null || renderInfo.value().length <= 0) continue;
            String[] renderName = renderInfo.value();
            this.suffix(renderName).bind((RenderEngine)((Object)target));
        }
    }

    protected static List<String> newArrayList(String[] arr, String object) {
        ArrayList<String> list = new ArrayList<String>();
        if (arr != null) {
            Collections.addAll(list, arr);
        }
        if (object != null) {
            list.add(object);
        }
        return list;
    }

    private class RenderEngineBindingBuilderImpl
    implements WebApiBinder.RenderEngineBindingBuilder<RenderEngine> {
        private List<String> suffixList = new ArrayList<String>();
        private boolean enable = false;

        public RenderEngineBindingBuilderImpl(List<String> suffixList) {
            LinkedHashSet<String> suffixSet = new LinkedHashSet<String>();
            for (String str : suffixList) {
                if (!StringUtils.isNotBlank((String)str)) continue;
                suffixSet.add(str.toUpperCase());
            }
            this.suffixList = new ArrayList<String>(suffixSet);
            this.enable = !this.suffixList.isEmpty();
        }

        @Override
        public void bind(Class<? extends RenderEngine> engineType) {
            if (this.enable) {
                RenderApiBinderImpl.this.bindSuffix(this.suffixList, (BindInfo<? extends RenderEngine>)RenderApiBinderImpl.this.bindType(RenderEngine.class).uniqueName().to(engineType).toInfo());
            }
        }

        @Override
        public void bind(RenderEngine engine) {
            if (this.enable) {
                RenderApiBinderImpl.this.bindSuffix(this.suffixList, (BindInfo<? extends RenderEngine>)RenderApiBinderImpl.this.bindType(RenderEngine.class).uniqueName().toInstance((Object)engine).toInfo());
            }
        }

        @Override
        public void bind(Provider<? extends RenderEngine> engineProvider) {
            if (this.enable) {
                RenderApiBinderImpl.this.bindSuffix(this.suffixList, (BindInfo<? extends RenderEngine>)RenderApiBinderImpl.this.bindType(RenderEngine.class).uniqueName().toProvider(engineProvider).toInfo());
            }
        }

        @Override
        public void bind(BindInfo<? extends RenderEngine> engineRegister) {
            if (this.enable) {
                RenderApiBinderImpl.this.bindSuffix(this.suffixList, (BindInfo<? extends RenderEngine>)((BindInfo)Hasor.assertIsNotNull(engineRegister)));
            }
        }
    }
}

