/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.mime;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.hasor.utils.IOUtils;
import net.hasor.utils.ResourcesUtils;
import net.hasor.utils.StringUtils;
import net.hasor.web.MimeType;
import net.hasor.web.mime.SaxXmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.helpers.DefaultHandler;

public class MimeTypeSupplier
extends ConcurrentHashMap<String, String>
implements MimeType {
    private static final long serialVersionUID = -8955832291109288048L;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private ServletContext content;

    public MimeTypeSupplier(ServletContext content) {
        this.content = content;
    }

    public ServletContext getContent() {
        return this.content;
    }

    @Override
    public String getMimeType(String suffix) {
        String mimeType = this.getContent().getMimeType(suffix);
        if (StringUtils.isNotBlank((String)mimeType)) {
            return mimeType;
        }
        return (String)this.get(suffix);
    }

    public void loadStream(String resourceName) throws IOException {
        List inStreamList = ResourcesUtils.getResourcesAsStream((String)resourceName);
        for (InputStream inStream : inStreamList) {
            this.loadStream(inStream);
        }
    }

    public void loadStream(InputStream inStream) throws IOException {
        try {
            this.logger.debug("parsing...");
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            factory.setFeature("http://xml.org/sax/features/namespaces", true);
            SAXParser parser = factory.newSAXParser();
            SaxXmlParser handler = new SaxXmlParser(this);
            parser.parse(inStream, (DefaultHandler)handler);
            IOUtils.closeQuietly((InputStream)inStream);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

