/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.invoker;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import net.hasor.core.AppContext;
import net.hasor.core.Settings;
import net.hasor.core.XmlNode;
import net.hasor.utils.ClassUtils;
import net.hasor.utils.StringUtils;
import net.hasor.web.Invoker;
import net.hasor.web.InvokerCreater;

class RootInvokerCreater
implements InvokerCreater {
    private Map<Class<?>, InvokerCreater> createrMap = new HashMap();
    private Map<Class<?>, Class<?>> extMapping = new HashMap();

    public RootInvokerCreater(AppContext appContext) throws Exception {
        Settings settings = appContext.getEnvironment().getSettings();
        ClassLoader classLoader = appContext.getClassLoader();
        HashMap extBinderMap = new HashMap();
        XmlNode[] nodeArray = settings.getXmlNodeArray("hasor.invokerCreaterSet.invokerCreater");
        if (nodeArray != null && nodeArray.length > 0) {
            for (XmlNode atNode : nodeArray) {
                Class[] interfaces;
                if (atNode == null) continue;
                String binderTypeStr = atNode.getAttribute("type");
                String binderImplStr = atNode.getText();
                if (StringUtils.isBlank((String)binderTypeStr) || StringUtils.isBlank((String)binderImplStr)) continue;
                Class<?> binderType = classLoader.loadClass(binderTypeStr);
                Class<?> binderImpl = classLoader.loadClass(binderImplStr);
                if (!binderType.isInterface()) continue;
                extBinderMap.put(binderType, binderImpl);
                for (Class faces : interfaces = ClassUtils.getAllInterfaces(binderType)) {
                    extBinderMap.put(faces, binderImpl);
                }
            }
        }
        for (Map.Entry entry : extBinderMap.entrySet()) {
            if (this.extMapping.containsKey(entry.getKey())) continue;
            Class createrType = (Class)entry.getValue();
            this.extMapping.put((Class<?>)entry.getKey(), createrType);
            if (this.createrMap.containsKey(createrType)) continue;
            InvokerCreater creater = (InvokerCreater)createrType.newInstance();
            this.createrMap.put(createrType, creater);
        }
    }

    @Override
    public Invoker createExt(Invoker dataContext) {
        HashMap extMap = new HashMap();
        for (Map.Entry<Class<?>, InvokerCreater> entry : this.createrMap.entrySet()) {
            Invoker extObject;
            Class<?> clazz = entry.getKey();
            InvokerCreater creater = entry.getValue();
            Invoker invoker = extObject = creater != null ? creater.createExt(dataContext) : null;
            if (clazz == null || extObject == null) continue;
            extMap.put(clazz, extObject);
        }
        HashMap supportMap = new HashMap();
        supportMap.put(Invoker.class, dataContext);
        for (Map.Entry<Class<?>, Class<?>> entry : this.extMapping.entrySet()) {
            Class<?> key = entry.getKey();
            Class<?> value = entry.getValue();
            Object obj = extMap.get(value);
            if (obj == null) continue;
            supportMap.put(key, obj);
        }
        ClassLoader classLoader = dataContext.getAppContext().getClassLoader();
        Class[] classArray = supportMap.keySet().toArray(new Class[supportMap.size()]);
        return (Invoker)Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)new InvokerCreaterInvocationHandler(supportMap));
    }

    private static class InvokerCreaterInvocationHandler
    implements InvocationHandler {
        private Map<Class<?>, Object> supportMap;

        public InvokerCreaterInvocationHandler(Map<Class<?>, Object> supportMap) {
            this.supportMap = supportMap;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class<?> declaringClass = method.getDeclaringClass();
            Object target = this.supportMap.get(declaringClass);
            if (target == null) {
                throw new UnsupportedOperationException("this method is not support -> " + method);
            }
            try {
                return method.invoke(target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

