/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.invoker;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.AppContext;
import net.hasor.utils.StringUtils;
import net.hasor.web.Invoker;
import net.hasor.web.MimeType;

public class InvokerSupplier
implements Invoker {
    private Set<String> lockKeys = new HashSet<String>();
    private HttpServletRequest httpRequest = null;
    private HttpServletResponse httpResponse = null;
    private AppContext appContext = null;
    private MimeType mimeType = null;
    private String requestPath;

    protected InvokerSupplier(AppContext appContext, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.appContext = appContext;
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.mimeType = (MimeType)appContext.getInstance(MimeType.class);
        String contextPath = this.getHttpRequest().getContextPath();
        String requestPath = this.getHttpRequest().getRequestURI();
        if (requestPath.startsWith(contextPath)) {
            requestPath = requestPath.substring(contextPath.length());
        }
        this.requestPath = requestPath;
        this.put("rootData", this);
        this.put("request", this.httpRequest);
        this.put("response", this.httpResponse);
        this.lockKey("rootData");
        this.lockKey("request");
        this.lockKey("response");
    }

    @Override
    public AppContext getAppContext() {
        return this.appContext;
    }

    @Override
    public HttpServletRequest getHttpRequest() {
        return this.httpRequest;
    }

    @Override
    public HttpServletResponse getHttpResponse() {
        return this.httpResponse;
    }

    @Override
    public Set<String> keySet() {
        Enumeration names = this.httpRequest.getAttributeNames();
        HashSet<String> nameSet = new HashSet<String>();
        while (names.hasMoreElements()) {
            nameSet.add((String)names.nextElement());
        }
        return nameSet;
    }

    @Override
    public Object get(String key) {
        return this.httpRequest.getAttribute(key);
    }

    @Override
    public void put(String key, Object value) {
        if (StringUtils.isBlank((String)key) || this.lockKeys.contains(key)) {
            throw new UnsupportedOperationException("the key '" + key + "' is lock key.");
        }
        this.httpRequest.setAttribute(key, value);
    }

    @Override
    public void remove(String key) {
        if (StringUtils.isBlank((String)key) || this.lockKeys.contains(key)) {
            throw new UnsupportedOperationException("the key '" + key + "' is lock key.");
        }
        this.httpRequest.removeAttribute(key);
    }

    @Override
    public void lockKey(String key) {
        if (StringUtils.isBlank((String)key)) {
            return;
        }
        this.lockKeys.add(key);
    }

    @Override
    public String getRequestPath() {
        return this.requestPath;
    }

    @Override
    public String getMimeType(String suffix) {
        return this.mimeType.getMimeType(suffix);
    }
}

