/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.invoker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.AppContext;
import net.hasor.core.Hasor;
import net.hasor.utils.Iterators;
import net.hasor.utils.future.BasicFuture;
import net.hasor.web.Invoker;
import net.hasor.web.InvokerChain;
import net.hasor.web.InvokerConfig;
import net.hasor.web.InvokerData;
import net.hasor.web.InvokerFilter;
import net.hasor.web.MappingSetup;
import net.hasor.web.WebPlugin;
import net.hasor.web.definition.AbstractDefinition;
import net.hasor.web.definition.WebPluginDefinition;
import net.hasor.web.invoker.ExceuteCaller;
import net.hasor.web.invoker.InMapping;
import net.hasor.web.invoker.InMappingDef;
import net.hasor.web.invoker.InvokerCaller;
import net.hasor.web.invoker.InvokerChainInvocation;
import net.hasor.web.invoker.InvokerSupplier;
import net.hasor.web.invoker.RootInvokerCreater;
import net.hasor.web.invoker.WebPluginCaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokerContext
implements WebPluginCaller {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private AppContext appContext = null;
    private InMapping[] invokeArray = new InMapping[0];
    private AbstractDefinition[] filters = new AbstractDefinition[0];
    private WebPlugin[] plugins = new WebPlugin[0];
    private RootInvokerCreater invokerCreater = null;

    public void initContext(final AppContext appContext, Map<String, String> configMap) throws Throwable {
        this.appContext = (AppContext)Hasor.assertIsNotNull((Object)appContext);
        final Map<String, String> config = Collections.unmodifiableMap(new HashMap<String, String>(configMap));
        List mappingList = appContext.findBindingBean(InMappingDef.class);
        Collections.sort(mappingList, new Comparator<InMappingDef>(){

            @Override
            public int compare(InMappingDef o1, InMappingDef o2) {
                return o1.getMappingTo().compareToIgnoreCase(o2.getMappingTo()) * -1;
            }
        });
        Collections.sort(mappingList, new Comparator<InMappingDef>(){

            @Override
            public int compare(InMappingDef o1, InMappingDef o2) {
                long o2Index;
                long o1Index = o1.getIndex();
                return o1Index < (o2Index = o2.getIndex()) ? -1 : (o1Index == o2Index ? 0 : 1);
            }
        });
        for (InMapping inMapping : this.invokeArray = mappingList.toArray(new InMapping[mappingList.size()])) {
            this.logger.info("mapingTo -> type \u2018{}\u2019 mappingTo: \u2018{}\u2019.", (Object)inMapping.getTargetType().getBindType(), (Object)inMapping.getMappingTo());
        }
        List pluginList = appContext.findBindingBean(WebPluginDefinition.class);
        this.plugins = pluginList.toArray(new WebPlugin[pluginList.size()]);
        for (WebPluginDefinition plugin : pluginList) {
            plugin.initPlugin(appContext);
            this.logger.info("webPlugin -> type \u2018{}\u2019.", (Object)plugin.toString());
        }
        List setupList = appContext.findBindingBean(MappingSetup.class);
        for (MappingSetup setup : setupList) {
            if (setup == null) continue;
            for (InMapping mapping : this.invokeArray) {
                if (mapping == null) continue;
                setup.setup(mapping);
            }
        }
        InvokerConfig filterConfig = new InvokerConfig(){

            @Override
            public String getInitParameter(String name) {
                return (String)config.get(name);
            }

            @Override
            public Enumeration<String> getInitParameterNames() {
                return Iterators.asEnumeration(config.keySet().iterator());
            }

            @Override
            public AppContext getAppContext() {
                return appContext;
            }
        };
        ArrayList finalList = new ArrayList();
        List filterList = appContext.findBindingBean(AbstractDefinition.class);
        Collections.sort(filterList, new Comparator<AbstractDefinition>(){

            @Override
            public int compare(AbstractDefinition o1, AbstractDefinition o2) {
                long o2Index;
                long o1Index = o1.getIndex();
                return o1Index < (o2Index = o2.getIndex()) ? -1 : (o1Index == o2Index ? 0 : 1);
            }
        });
        finalList.addAll(filterList);
        for (InvokerFilter filter : finalList) {
            filter.init(filterConfig);
        }
        this.filters = finalList.toArray(new AbstractDefinition[finalList.size()]);
        this.invokerCreater = new RootInvokerCreater(appContext);
    }

    public void destroyContext() {
        for (AbstractDefinition filter : this.filters) {
            filter.destroy();
        }
    }

    public Invoker newInvoker(HttpServletRequest request, HttpServletResponse response) {
        return this.invokerCreater.createExt(new InvokerSupplier(this.appContext, request, response));
    }

    public ExceuteCaller genCaller(Invoker invoker) {
        InMapping foundDefine = null;
        for (InMapping define : this.invokeArray) {
            if (!define.matchingMapping(invoker)) continue;
            foundDefine = define;
            break;
        }
        if (foundDefine == null) {
            return new ExceuteCaller(){

                @Override
                public Future<Object> invoke(Invoker invoker, final FilterChain chain) throws Throwable {
                    new InvokerChainInvocation(InvokerContext.this.filters, new InvokerChain(){

                        @Override
                        public void doNext(Invoker invoker) throws Throwable {
                            chain.doFilter((ServletRequest)invoker.getHttpRequest(), (ServletResponse)invoker.getHttpResponse());
                        }
                    }).doNext(invoker);
                    BasicFuture future = new BasicFuture();
                    future.completed(null);
                    return future;
                }
            };
        }
        return new InvokerCaller(foundDefine, this.filters, this);
    }

    @Override
    public void beforeFilter(Invoker invoker, InvokerData define) {
        for (WebPlugin plugin : this.plugins) {
            plugin.beforeFilter(invoker, define);
        }
    }

    @Override
    public void afterFilter(Invoker invoker, InvokerData define) {
        for (WebPlugin plugin : this.plugins) {
            plugin.afterFilter(invoker, define);
        }
    }
}

