/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.invoker;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.AsyncContext;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.hasor.utils.BeanUtils;
import net.hasor.utils.StringUtils;
import net.hasor.utils.convert.ConverterUtils;
import net.hasor.utils.future.BasicFuture;
import net.hasor.web.Controller;
import net.hasor.web.Invoker;
import net.hasor.web.InvokerChain;
import net.hasor.web.InvokerData;
import net.hasor.web.MappingData;
import net.hasor.web.ServletVersion;
import net.hasor.web.annotation.AttributeParam;
import net.hasor.web.annotation.CookieParam;
import net.hasor.web.annotation.HeaderParam;
import net.hasor.web.annotation.IgnoreParam;
import net.hasor.web.annotation.Params;
import net.hasor.web.annotation.PathParam;
import net.hasor.web.annotation.QueryParam;
import net.hasor.web.annotation.ReqParam;
import net.hasor.web.definition.AbstractDefinition;
import net.hasor.web.invoker.AsyncInvocationWorker;
import net.hasor.web.invoker.ExceuteCaller;
import net.hasor.web.invoker.InMapping;
import net.hasor.web.invoker.InvokerChainInvocation;
import net.hasor.web.invoker.WebPluginCaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InvokerCaller
implements ExceuteCaller {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private InMapping mappingToDefine = null;
    private AbstractDefinition[] filterArrays = null;
    private WebPluginCaller pluginCaller = null;
    private Map<String, List<String>> queryParamLocal = null;
    private Map<String, Object> pathParamsLocal = null;

    public InvokerCaller(InMapping mappingToDefine, AbstractDefinition[] filterArrays, WebPluginCaller pluginCaller) {
        this.mappingToDefine = mappingToDefine;
        this.filterArrays = filterArrays == null ? new AbstractDefinition[]{} : filterArrays;
        this.pluginCaller = pluginCaller;
    }

    @Override
    public Future<Object> invoke(final Invoker invoker, FilterChain chain) throws Throwable {
        final BasicFuture future = new BasicFuture();
        Method targetMethod = this.mappingToDefine.findMethod(invoker);
        if (targetMethod == null) {
            chain.doFilter((ServletRequest)invoker.getHttpRequest(), (ServletResponse)invoker.getHttpResponse());
            future.completed(null);
            return future;
        }
        try {
            boolean needAsync = this.mappingToDefine.isAsync(invoker);
            ServletVersion version = (ServletVersion)((Object)invoker.getAppContext().getInstance(ServletVersion.class));
            if (version.ge(ServletVersion.V3_0) && needAsync) {
                AsyncContext asyncContext = invoker.getHttpRequest().startAsync();
                asyncContext.start((Runnable)new AsyncInvocationWorker(asyncContext, targetMethod){

                    @Override
                    public void doWork(Method targetMethod) throws Throwable {
                        try {
                            Object invoke = InvokerCaller.this.invoke(targetMethod, invoker);
                            future.completed(invoke);
                        }
                        catch (Throwable e) {
                            future.failed(e);
                        }
                    }
                });
                return future;
            }
        }
        catch (Throwable needAsync) {
            // empty catch block
        }
        try {
            Object invoke = this.invoke(targetMethod, invoker);
            future.completed(invoke);
        }
        catch (Throwable e) {
            future.failed(e);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invoke(final Method targetMethod, Invoker invoker) throws Throwable {
        final Object targetObject = this.mappingToDefine.newInstance(invoker);
        if (targetObject != null && targetObject instanceof Controller) {
            ((Controller)targetObject).initController(invoker);
        }
        final ArrayList<Object[]> resolveParams = new ArrayList<Object[]>(1);
        InvokerChain invokerChain = new InvokerChain(){

            @Override
            public void doNext(Invoker invoker) throws Throwable {
                Object result = targetMethod.invoke(targetObject, (Object[])resolveParams.get(0));
                invoker.put("resultData", result);
            }
        };
        InvokerData invokerData = new InvokerData(){

            @Override
            public Method targetMethod() {
                return targetMethod;
            }

            @Override
            public Object[] getParameters() {
                return resolveParams.isEmpty() ? new Object[]{} : (Object[])resolveParams.get(0);
            }

            @Override
            public MappingData getMappingTo() {
                return InvokerCaller.this.mappingToDefine;
            }
        };
        try {
            Object[] resolveParamsArrays = this.resolveParams(invoker, targetMethod);
            resolveParams.add(0, resolveParamsArrays);
            this.pluginCaller.beforeFilter(invoker, invokerData);
            new InvokerChainInvocation(this.filterArrays, invokerChain).doNext(invoker);
        }
        finally {
            this.pluginCaller.afterFilter(invoker, invokerData);
        }
        return invoker.get("resultData");
    }

    private Object[] resolveParams(Invoker invoker, Method targetMethod) throws Throwable {
        Class<?>[] targetParamClass = targetMethod.getParameterTypes();
        Annotation[][] targetParamAnno = targetMethod.getParameterAnnotations();
        targetParamClass = targetParamClass == null ? new Class[]{} : targetParamClass;
        targetParamAnno = targetParamAnno == null ? new Annotation[0][0] : targetParamAnno;
        ArrayList<Object> paramsArray = new ArrayList<Object>();
        for (int i = 0; i < targetParamClass.length; ++i) {
            Class<?> paramClass = targetParamClass[i];
            Object paramObject = this.resolveParam(invoker, paramClass, targetParamAnno[i]);
            paramsArray.add(paramObject);
        }
        Object[] invokeParams = paramsArray.toArray();
        return invokeParams;
    }

    private Object resolveParam(Invoker invoker, Class<?> paramClass, Annotation[] paramAnno) {
        Object specialParam = this.resolveSpecialParam(invoker, paramClass);
        if (specialParam != null) {
            return specialParam;
        }
        for (Annotation pAnno : paramAnno) {
            Object finalValue = this.resolveParam(invoker, paramClass, pAnno);
            if ((finalValue = ConverterUtils.convert(paramClass, (Object)finalValue)) == null) continue;
            return finalValue;
        }
        return BeanUtils.getDefaultValue(paramClass);
    }

    private Object resolveSpecialParam(Invoker invoker, Class<?> paramClass) {
        if (!paramClass.isInterface()) {
            return null;
        }
        if (paramClass == ServletRequest.class || paramClass == HttpServletRequest.class) {
            return invoker.getHttpRequest();
        }
        if (paramClass == ServletResponse.class || paramClass == HttpServletResponse.class) {
            return invoker.getHttpResponse();
        }
        if (paramClass == HttpSession.class) {
            return invoker.getHttpRequest().getSession(true);
        }
        if (paramClass == Invoker.class) {
            return invoker;
        }
        if (paramClass.isInterface() && paramClass.isInstance(invoker)) {
            return invoker;
        }
        return invoker.getAppContext().getInstance(paramClass);
    }

    private Object resolveParam(Invoker invoker, Class<?> paramClass, Annotation pAnno) {
        Object atData = null;
        if (pAnno instanceof AttributeParam) {
            atData = this.getAttributeParam(invoker, (AttributeParam)pAnno);
        } else if (pAnno instanceof CookieParam) {
            atData = this.getCookieParam(invoker, (CookieParam)pAnno);
        } else if (pAnno instanceof HeaderParam) {
            atData = this.getHeaderParam(invoker, (HeaderParam)pAnno);
        } else if (pAnno instanceof QueryParam) {
            atData = this.getQueryParam(invoker, (QueryParam)pAnno);
        } else if (pAnno instanceof PathParam) {
            atData = this.getPathParam(invoker, (PathParam)pAnno);
        } else if (pAnno instanceof ReqParam) {
            atData = invoker.getHttpRequest().getParameterValues(((ReqParam)pAnno).value());
        } else if (pAnno instanceof Params) {
            atData = this.getParamsParam(invoker, paramClass);
        }
        return atData;
    }

    private Object getParamsParam(Invoker invoker, Class<?> paramClass) {
        Object paramObject = null;
        try {
            paramObject = paramClass.newInstance();
        }
        catch (Throwable e) {
            this.logger.error(paramClass.getName() + "newInstance error.", (Object)e.getMessage());
            return paramObject;
        }
        List fieldList = BeanUtils.findALLFields(paramClass);
        if (fieldList == null || fieldList.isEmpty()) {
            return paramObject;
        }
        for (Field field : fieldList) {
            if (field.isAnnotationPresent(IgnoreParam.class)) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug(field + " -> Ignore.");
                continue;
            }
            try {
                Object fieldValue = null;
                Annotation[] annos = field.getAnnotations();
                fieldValue = annos == null || annos.length == 0 ? invoker.getHttpRequest().getParameterValues(field.getName()) : this.resolveParam(invoker, field.getType(), annos);
                if (fieldValue == null) {
                    fieldValue = BeanUtils.getDefaultValue(field.getType());
                }
                fieldValue = ConverterUtils.convert(field.getType(), (Object)fieldValue);
                field.setAccessible(true);
                field.set(paramObject, fieldValue);
            }
            catch (Exception e) {
                this.logger.error(field + "set new Value error.", (Object)e.getMessage());
            }
        }
        return paramObject;
    }

    private Object getPathParam(Invoker invoker, PathParam pAnno) {
        String paramName = pAnno.value();
        return StringUtils.isBlank((String)paramName) ? null : this.getPathParamMap(invoker).get(paramName);
    }

    private Object getQueryParam(Invoker invoker, QueryParam pAnno) {
        String paramName = pAnno.value();
        return StringUtils.isBlank((String)paramName) ? null : this.getQueryParamMap(invoker).get(paramName);
    }

    private Object getHeaderParam(Invoker invoker, HeaderParam pAnno) {
        String paramName = pAnno.value();
        if (StringUtils.isBlank((String)paramName)) {
            return null;
        }
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        Enumeration e = httpRequest.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement().toString();
            if (!name.equalsIgnoreCase(paramName)) continue;
            ArrayList headerList = new ArrayList();
            Enumeration v = httpRequest.getHeaders(paramName);
            while (v.hasMoreElements()) {
                headerList.add(v.nextElement());
            }
            return headerList;
        }
        return null;
    }

    private Object getCookieParam(Invoker invoker, CookieParam pAnno) {
        String paramName = pAnno.value();
        if (StringUtils.isBlank((String)paramName)) {
            return null;
        }
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        Cookie[] cookies = httpRequest.getCookies();
        ArrayList<String> cookieList = new ArrayList<String>();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String cookieName = cookie.getName();
                if (cookieName == null || !cookieName.equalsIgnoreCase(paramName)) continue;
                cookieList.add(cookie.getValue());
            }
        }
        return cookieList;
    }

    private Object getAttributeParam(Invoker invoker, AttributeParam pAnno) {
        String paramName = pAnno.value();
        if (StringUtils.isBlank((String)paramName)) {
            return null;
        }
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        Enumeration e = httpRequest.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement().toString();
            if (!name.equalsIgnoreCase(paramName)) continue;
            return httpRequest.getAttribute(paramName);
        }
        return null;
    }

    private Map<String, List<String>> getQueryParamMap(Invoker invoker) {
        String[] params;
        if (this.queryParamLocal != null) {
            return this.queryParamLocal;
        }
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        String queryString = httpRequest.getQueryString();
        if (StringUtils.isBlank((String)queryString)) {
            return Collections.EMPTY_MAP;
        }
        this.queryParamLocal = new HashMap<String, List<String>>();
        String[] stringArray = params = queryString.split("&");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String oriData;
            block6: {
                String pData;
                oriData = pData = stringArray[i];
                String encoding = httpRequest.getCharacterEncoding();
                try {
                    if (encoding == null) break block6;
                    oriData = URLDecoder.decode(pData, encoding);
                }
                catch (Exception e) {
                    this.logger.warn("use \u2018{}\u2019 decode \u2018{}\u2019 error.", (Object)encoding, (Object)pData);
                    continue;
                }
            }
            String[] kv = oriData.split("=");
            if (kv.length < 2) continue;
            String k = kv[0].trim();
            String v = kv[1];
            ArrayList<String> pArray = this.queryParamLocal.get(k);
            ArrayList<String> arrayList = pArray = pArray == null ? new ArrayList<String>() : pArray;
            if (!pArray.contains(v)) {
                pArray.add(v);
            }
            this.queryParamLocal.put(k, pArray);
        }
        return this.queryParamLocal;
    }

    private Map<String, Object> getPathParamMap(Invoker invoker) {
        if (this.pathParamsLocal != null) {
            return this.pathParamsLocal;
        }
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        String requestPath = httpRequest.getRequestURI().substring(httpRequest.getContextPath().length());
        String matchVar = this.mappingToDefine.getMappingToMatches();
        String matchKey = "(?:\\{(\\w+)\\}){1,}";
        Matcher keyM = Pattern.compile(matchKey).matcher(this.mappingToDefine.getMappingTo());
        Matcher varM = Pattern.compile(matchVar).matcher(requestPath);
        ArrayList<String> keyArray = new ArrayList<String>();
        ArrayList<String> varArray = new ArrayList<String>();
        while (keyM.find()) {
            keyArray.add(keyM.group(1));
        }
        varM.find();
        for (int i = 1; i <= varM.groupCount(); ++i) {
            varArray.add(varM.group(i));
        }
        HashMap<String, List> uriParams = new HashMap<String, List>();
        for (int i = 0; i < keyArray.size(); ++i) {
            String k = (String)keyArray.get(i);
            String v = (String)varArray.get(i);
            List pArray = (List)uriParams.get(k);
            List list = pArray = pArray == null ? new ArrayList() : pArray;
            if (!pArray.contains(v)) {
                pArray.add(v);
            }
            uriParams.put(k, pArray);
        }
        this.pathParamsLocal = new HashMap<String, Object>();
        for (Map.Entry ent : uriParams.entrySet()) {
            String k = (String)ent.getKey();
            List v = (List)ent.getValue();
            this.pathParamsLocal.put(k, v.toArray(new String[v.size()]));
        }
        return this.pathParamsLocal;
    }
}

