/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.invoker;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import net.hasor.core.AppContext;
import net.hasor.core.BindInfo;
import net.hasor.utils.ExceptionUtils;
import net.hasor.utils.Iterators;
import net.hasor.web.Invoker;
import net.hasor.web.invoker.InMappingDef;

public class InMappingServlet
extends InMappingDef {
    private Map<String, String> initParams;
    private Object servlet;

    public InMappingServlet(long index, BindInfo<? extends HttpServlet> targetType, String mappingTo, Map<String, String> initParams) {
        super(index, targetType, mappingTo, InMappingServlet.findMethod(), true);
        this.initParams = initParams;
    }

    private static List<Method> findMethod() {
        try {
            Method serviceMethod = HttpServlet.class.getMethod("service", ServletRequest.class, ServletResponse.class);
            return Arrays.asList(serviceMethod);
        }
        catch (NoSuchMethodException e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object newInstance(Invoker invoker) throws Throwable {
        if (this.servlet != null) {
            return this.servlet;
        }
        InMappingServlet inMappingServlet = this;
        synchronized (inMappingServlet) {
            if (this.servlet != null) {
                return this.servlet;
            }
            final AppContext appContext = invoker.getAppContext();
            this.servlet = super.newInstance(invoker);
            ((Servlet)this.servlet).init(new ServletConfig(){

                public String getServletName() {
                    return InMappingServlet.this.getTargetType().toString();
                }

                public ServletContext getServletContext() {
                    return (ServletContext)appContext.getInstance(ServletContext.class);
                }

                public String getInitParameter(String name) {
                    return (String)InMappingServlet.this.initParams.get(name);
                }

                public Enumeration<String> getInitParameterNames() {
                    return Iterators.asEnumeration(InMappingServlet.this.initParams.keySet().iterator());
                }
            });
        }
        return this.servlet;
    }
}

