/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.invoker;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.hasor.core.BindInfo;
import net.hasor.core.Hasor;
import net.hasor.utils.StringUtils;
import net.hasor.web.Invoker;
import net.hasor.web.annotation.Async;
import net.hasor.web.annotation.HttpMethod;
import net.hasor.web.invoker.AsyncSupported;
import net.hasor.web.invoker.InMapping;

public class InMappingDef
implements InMapping {
    private final long index;
    private BindInfo<?> targetType;
    private String mappingTo;
    private String mappingToMatches;
    private Map<String, Method> httpMapping;
    private Set<Method> asyncMethod;
    private AsyncSupported defaultAsync = AsyncSupported.no;

    public InMappingDef(long index, BindInfo<?> targetType, String mappingTo, List<Method> methodList, boolean force) {
        this.index = index;
        this.targetType = (BindInfo)Hasor.assertIsNotNull(targetType);
        String servicePath = (String)Hasor.assertIsNotNull((Object)mappingTo);
        if (StringUtils.isBlank((String)servicePath)) {
            throw new NullPointerException("'" + targetType.getBindType() + "' Service path is empty.");
        }
        if (!servicePath.matches("/.+")) {
            throw new IllegalStateException("'" + targetType.getBindType() + "' Service path format error, must be a '/' at the start.");
        }
        if (targetType.getBindType().getAnnotation(Async.class) != null) {
            this.defaultAsync = AsyncSupported.yes;
        }
        this.mappingTo = servicePath;
        this.mappingToMatches = InMappingDef.wildToRegex(servicePath).replaceAll("\\{\\w{1,}\\}", "([^/]{1,})");
        this.httpMapping = new HashMap<String, Method>();
        this.asyncMethod = new HashSet<Method>();
        if (methodList == null || methodList.isEmpty()) {
            return;
        }
        for (Method targetMethod : methodList) {
            Annotation[] annos = targetMethod.getAnnotations();
            if (annos != null) {
                for (Annotation anno : annos) {
                    String bindMethod;
                    HttpMethod httpMethodAnno = anno.annotationType().getAnnotation(HttpMethod.class);
                    if (httpMethodAnno == null || StringUtils.isBlank((String)(bindMethod = httpMethodAnno.value()))) continue;
                    this.httpMapping.put(bindMethod.toUpperCase(), targetMethod);
                }
            }
            if (targetMethod.getName().equals("execute") && !this.httpMapping.containsKey("execute")) {
                this.httpMapping.put("ANY", targetMethod);
            }
            if (targetMethod.getAnnotation(Async.class) != null) {
                this.asyncMethod.add(targetMethod);
            }
            if (this.httpMapping.containsValue(targetMethod) || !force) continue;
            this.httpMapping.put("ANY", targetMethod);
        }
    }

    private static String wildToRegex(String wild) {
        wild = wild.replace("\\", "\\\\");
        wild = wild.replace("$", "\\$");
        wild = wild.replace("^", "\\^");
        wild = wild.replace("[", "\\[");
        wild = wild.replace("]", "\\]");
        wild = wild.replace("(", "\\(");
        wild = wild.replace(")", "\\)");
        wild = wild.replace("|", "\\|");
        wild = wild.replace("+", "\\+");
        wild = wild.replace(".", "\\.");
        wild = wild.replace("*", ".*");
        wild = wild.replace("?", ".");
        return wild;
    }

    @Override
    public BindInfo<?> getTargetType() {
        return this.targetType;
    }

    @Override
    public String getMappingTo() {
        return this.mappingTo;
    }

    @Override
    public String getMappingToMatches() {
        return this.mappingToMatches;
    }

    public long getIndex() {
        return this.index;
    }

    @Override
    public Method[] getMethods() {
        return this.httpMapping.values().toArray(new Method[this.httpMapping.size()]);
    }

    @Override
    public boolean matchingMapping(Invoker invoker) {
        String httpMethod = invoker.getHttpRequest().getMethod();
        String requestPath = invoker.getRequestPath();
        Hasor.assertIsNotNull((Object)requestPath, (String)"requestPath is null.");
        if (!requestPath.matches(this.mappingToMatches)) {
            return false;
        }
        for (String m : this.httpMapping.keySet()) {
            if (httpMethod.equals(m)) {
                return true;
            }
            if (!"ANY".equals(m)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Method findMethod(Invoker invoker) {
        String requestPath = invoker.getRequestPath();
        Hasor.assertIsNotNull((Object)requestPath, (String)"requestPath is null.");
        if (!requestPath.matches(this.mappingToMatches)) {
            return null;
        }
        String httpMethod = invoker.getHttpRequest().getMethod();
        Method targetMethod = this.httpMapping.get(httpMethod.trim().toUpperCase());
        if (targetMethod == null) {
            targetMethod = this.httpMapping.get("ANY");
        }
        return targetMethod;
    }

    @Override
    public boolean isAsync(Invoker invoker) {
        Method targetMethod = this.findMethod(invoker);
        if (targetMethod == null) {
            return false;
        }
        AsyncSupported async = this.asyncMethod.contains(targetMethod) ? AsyncSupported.yes : this.defaultAsync;
        return async == AsyncSupported.yes;
    }

    @Override
    public Object newInstance(Invoker invoker) throws Throwable {
        return invoker.getAppContext().getInstance(this.getTargetType());
    }

    public String toString() {
        return String.format("pattern=%s ,methodSet=%s ,type %s", this.mappingTo, StringUtils.join((Object[])this.httpMapping.keySet().toArray(), (String)","), this.getTargetType());
    }
}

