/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.hasor.core.AppContext;
import net.hasor.core.Hasor;
import net.hasor.core.Settings;
import net.hasor.utils.IOUtils;
import net.hasor.utils.StringUtils;
import net.hasor.web.Controller;
import net.hasor.web.FileItem;
import net.hasor.web.FileItemFactory;
import net.hasor.web.FileItemStream;
import net.hasor.web.Invoker;
import net.hasor.web.RenderInvoker;
import net.hasor.web.startup.RuntimeListener;
import net.hasor.web.upload.FileUpload;
import net.hasor.web.upload.factorys.disk.DiskFileItemFactory;

public class WebController
implements Controller {
    private ThreadLocal<Invoker> invoker = new ThreadLocal();

    @Override
    public void initController(Invoker renderData) {
        if (this.invoker.get() != null) {
            this.invoker.remove();
        }
        if (renderData != null) {
            this.invoker.set(renderData);
        }
    }

    protected Invoker getInvoker() {
        return this.invoker.get();
    }

    public HttpServletRequest getRequest() {
        return this.getInvoker().getHttpRequest();
    }

    public HttpServletResponse getResponse() {
        return this.getInvoker().getHttpResponse();
    }

    public AppContext getAppContext() {
        return RuntimeListener.getAppContext(this.getRequest().getSession().getServletContext());
    }

    protected WebController setHeader(String key, String value) {
        this.getResponse().setHeader(key, value);
        return this;
    }

    protected WebController addHeader(String key, String value) {
        this.getResponse().addHeader(key, value);
        return this;
    }

    protected String getPara(String name) {
        return this.getRequest().getParameter(name);
    }

    protected String getPara(String name, String defaultValue) {
        String result = this.getRequest().getParameter(name);
        return result != null && !"".equals(result) ? result : defaultValue;
    }

    protected Map<String, String[]> getParaMap() {
        return this.getRequest().getParameterMap();
    }

    protected Enumeration<String> getParaNames() {
        return this.getRequest().getParameterNames();
    }

    protected String[] getParaValues(String name) {
        return this.getRequest().getParameterValues(name);
    }

    protected Integer[] getParaValuesToInt(String name) {
        String[] values = this.getRequest().getParameterValues(name);
        if (values == null) {
            return null;
        }
        Integer[] result = new Integer[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Integer.parseInt(values[i]);
        }
        return result;
    }

    protected Integer getParaToInt(String name) {
        return this.toInt(this.getRequest().getParameter(name), null);
    }

    protected Integer getParaToInt(String name, Integer defaultValue) {
        return this.toInt(this.getRequest().getParameter(name), defaultValue);
    }

    private Integer toInt(String value, Integer defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value.startsWith("N") || value.startsWith("n")) {
            return -Integer.parseInt(value.substring(1));
        }
        return Integer.parseInt(value);
    }

    protected Long getParaToLong(String name) {
        return this.toLong(this.getRequest().getParameter(name), null);
    }

    protected Long getParaToLong(String name, Long defaultValue) {
        return this.toLong(this.getRequest().getParameter(name), defaultValue);
    }

    private long toLong(String value, Long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value.startsWith("N") || value.startsWith("n")) {
            return -Long.parseLong(value.substring(1));
        }
        return Long.parseLong(value);
    }

    protected Boolean getParaToBoolean(String name) {
        String result = this.getRequest().getParameter(name);
        if (result != null) {
            if ((result = result.trim().toLowerCase()).equals("1") || result.equals("true")) {
                return Boolean.TRUE;
            }
            if (result.equals("0") || result.equals("false")) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    protected Boolean getParaToBoolean(String name, Boolean defaultValue) {
        Boolean result = this.getParaToBoolean(name);
        return result != null ? result : defaultValue;
    }

    protected HttpSession getSession() {
        return this.getRequest().getSession();
    }

    protected HttpSession getSession(boolean create) {
        return this.getRequest().getSession(create);
    }

    protected <T> T getSessionAttr(String key) {
        HttpSession session = this.getRequest().getSession(false);
        return (T)(session != null ? session.getAttribute(key) : null);
    }

    protected WebController setSessionAttr(String key, Object value) {
        this.getRequest().getSession(true).setAttribute(key, value);
        return this;
    }

    protected WebController removeSessionAttr(String key) {
        HttpSession session = this.getRequest().getSession(false);
        if (session != null) {
            session.removeAttribute(key);
        }
        return this;
    }

    protected String getCookie(String name, String defaultValue) {
        Cookie cookie = this.getCookieObject(name);
        return cookie != null ? cookie.getValue() : defaultValue;
    }

    protected String getCookie(String name) {
        return this.getCookie(name, null);
    }

    protected Integer getCookieToInt(String name) {
        String result = this.getCookie(name);
        return result != null ? Integer.valueOf(Integer.parseInt(result)) : null;
    }

    protected Integer getCookieToInt(String name, Integer defaultValue) {
        String result = this.getCookie(name);
        return result != null ? Integer.parseInt(result) : defaultValue;
    }

    protected Long getCookieToLong(String name) {
        String result = this.getCookie(name);
        return result != null ? Long.valueOf(Long.parseLong(result)) : null;
    }

    protected Long getCookieToLong(String name, Long defaultValue) {
        String result = this.getCookie(name);
        return result != null ? Long.parseLong(result) : defaultValue;
    }

    protected Cookie getCookieObject(String name) {
        Cookie[] cookies = this.getRequest().getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
        }
        return null;
    }

    protected Cookie[] getCookieObjects() {
        Cookie[] result = this.getRequest().getCookies();
        return result != null ? result : new Cookie[]{};
    }

    protected WebController setCookie(Cookie cookie) {
        this.getResponse().addCookie(cookie);
        return this;
    }

    protected WebController setCookie(String name, String value, int maxAgeInSeconds, String path) {
        this.setCookie(name, value, maxAgeInSeconds, path, null);
        return this;
    }

    protected WebController setCookie(String name, String value, int maxAgeInSeconds, String path, String domain) {
        Cookie cookie = new Cookie(name, value);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        cookie.setMaxAge(maxAgeInSeconds);
        cookie.setPath(path);
        this.getResponse().addCookie(cookie);
        return this;
    }

    protected WebController setCookie(String name, String value, int maxAgeInSeconds) {
        this.setCookie(name, value, maxAgeInSeconds, "/", null);
        return this;
    }

    protected WebController removeCookie(String name) {
        this.setCookie(name, null, 0, "/", null);
        return this;
    }

    protected WebController removeCookie(String name, String path) {
        this.setCookie(name, null, 0, path, null);
        return this;
    }

    protected WebController removeCookie(String name, String path, String domain) {
        this.setCookie(name, null, 0, path, domain);
        return this;
    }

    protected <T> T getAttr(String name) {
        return (T)this.getRequest().getAttribute(name);
    }

    protected WebController setAttr(String name, Object value) {
        this.getRequest().setAttribute(name, value);
        return this;
    }

    protected WebController removeAttr(String name) {
        this.getRequest().removeAttribute(name);
        return this;
    }

    protected WebController setAttrs(Map<String, Object> attrMap) {
        for (Map.Entry<String, Object> entry : attrMap.entrySet()) {
            this.getRequest().setAttribute(entry.getKey(), entry.getValue());
        }
        return this;
    }

    protected Enumeration<String> getAttrNames() {
        return this.getRequest().getAttributeNames();
    }

    protected <T> T getData(String name) {
        return (T)this.getInvoker().get(name);
    }

    protected WebController putData(String name, Object value) {
        this.getInvoker().put(name, value);
        return this;
    }

    protected WebController removeData(String name) {
        this.getInvoker().remove(name);
        return this;
    }

    protected WebController setDatas(Map<String, Object> attrMap) {
        for (Map.Entry<String, Object> entry : attrMap.entrySet()) {
            this.getInvoker().put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    protected Set<String> getDataNames() {
        return this.getInvoker().keySet();
    }

    protected <T> T getInstance(Class<T> modelClass, String modelName) {
        return (T)this.getAppContext().findBindingBean(modelName, modelClass);
    }

    protected <T> T getInstance(Class<T> modelClass) {
        return (T)this.getAppContext().getInstance(modelClass);
    }

    protected Object getInstance(String bindID) {
        return this.getAppContext().getInstance(bindID);
    }

    protected void renderTo(String viewName) {
        Invoker invoker = this.getInvoker();
        if (invoker != null && invoker instanceof RenderInvoker) {
            RenderInvoker render = (RenderInvoker)invoker;
            render.renderTo(viewName);
        }
    }

    protected void renderTo(String renderType, String viewName) {
        Invoker invoker = this.getInvoker();
        if (invoker != null && invoker instanceof RenderInvoker) {
            RenderInvoker render = (RenderInvoker)invoker;
            render.renderTo(renderType, viewName);
        }
    }

    protected boolean isMultipart() {
        return FileUpload.isMultipartContent(this.getRequest());
    }

    protected List<FileItem> getMultipartList() throws IOException {
        return this.getMultipartList((String)null, null, null);
    }

    protected List<FileItem> getMultipartList(Integer maxPostSize) throws IOException {
        return this.getMultipartList((String)null, maxPostSize, null);
    }

    protected List<FileItem> getMultipartList(String cacheDirectory, Integer maxPostSize) throws IOException {
        return this.getMultipartList(cacheDirectory, maxPostSize, null);
    }

    protected List<FileItem> getMultipartList(String cacheDirectory, Integer maxPostSize, String encoding) throws IOException {
        if (StringUtils.isBlank((String)(cacheDirectory = IOUtils.normalizeNoEndSeparator((String)cacheDirectory)))) {
            Settings settings = this.getAppContext().getEnvironment().getSettings();
            cacheDirectory = settings.getDirectoryPath("hasor.fileupload.cacheDirectory");
        }
        return this.getMultipartList(new DiskFileItemFactory(cacheDirectory), maxPostSize, encoding);
    }

    protected List<FileItem> getMultipartList(FileItemFactory factory) throws IOException {
        return this.getMultipartList(factory, null, null);
    }

    protected List<FileItem> getMultipartList(FileItemFactory factory, Integer maxPostSize) throws IOException {
        return this.getMultipartList(factory, maxPostSize, null);
    }

    protected List<FileItem> getMultipartList(FileItemFactory factory, Integer maxPostSize, String encoding) throws IOException {
        FileUpload upload = this.newFileUpload(maxPostSize, encoding);
        if (upload == null) {
            return null;
        }
        return upload.parseRequest(this.getRequest(), factory);
    }

    protected List<FileItem> getMultipart(String parameterName) throws IOException {
        return this.getMultipart(parameterName, null, null, null);
    }

    protected List<FileItem> getMultipart(String parameterName, Integer maxPostSize) throws IOException {
        return this.getMultipart(parameterName, null, maxPostSize, null);
    }

    protected List<FileItem> getMultipart(String parameterName, String cacheDirectory, Integer maxPostSize) throws IOException {
        return this.getMultipart(parameterName, cacheDirectory, maxPostSize, null);
    }

    protected List<FileItem> getMultipart(String parameterName, String cacheDirectory, Integer maxPostSize, String encoding) throws IOException {
        Hasor.assertIsNotNull((Object)parameterName);
        List<FileItem> itemList = this.getMultipartList(cacheDirectory, maxPostSize, encoding);
        if (itemList == null || itemList.isEmpty()) {
            return null;
        }
        ArrayList<FileItem> resultData = new ArrayList<FileItem>();
        for (FileItem item : itemList) {
            if (parameterName.equals(item.getFieldName())) {
                resultData.add(item);
                continue;
            }
            item.deleteOrSkip();
        }
        return resultData;
    }

    protected FileItem getOneMultipart(String parameterName) throws IOException {
        return this.getOneMultipart(parameterName, null, null, null);
    }

    protected FileItem getOneMultipart(String parameterName, Integer maxPostSize) throws IOException {
        return this.getOneMultipart(parameterName, null, maxPostSize, null);
    }

    protected FileItem getOneMultipart(String parameterName, String cacheDirectory, Integer maxPostSize) throws IOException {
        return this.getOneMultipart(parameterName, cacheDirectory, maxPostSize, null);
    }

    protected FileItem getOneMultipart(String parameterName, String cacheDirectory, Integer maxPostSize, String encoding) throws IOException {
        Hasor.assertIsNotNull((Object)parameterName);
        List<FileItem> itemList = this.getMultipartList(cacheDirectory, maxPostSize, encoding);
        if (itemList == null || itemList.isEmpty()) {
            return null;
        }
        FileItem findItem = null;
        for (FileItem item : itemList) {
            if (findItem == null && parameterName.equals(item.getFieldName())) {
                findItem = item;
                continue;
            }
            item.deleteOrSkip();
        }
        return findItem;
    }

    protected Iterator<FileItemStream> getMultipartIterator() throws IOException {
        return this.getMultipartIterator(null, null);
    }

    protected Iterator<FileItemStream> getMultipartIterator(Integer maxPostSize) throws IOException {
        return this.getMultipartIterator(maxPostSize, null);
    }

    protected Iterator<FileItemStream> getMultipartIterator(Integer maxPostSize, String encoding) throws IOException {
        FileUpload upload = this.newFileUpload(maxPostSize, encoding);
        if (upload == null) {
            return null;
        }
        return upload.getItemIterator(this.getRequest());
    }

    protected FileUpload newFileUpload(Integer maxPostSize, String encoding) {
        if (!this.isMultipart()) {
            return null;
        }
        FileUpload upload = new FileUpload(this.getAppContext().getEnvironment().getSettings());
        if (maxPostSize != null) {
            upload.setSizeMax(maxPostSize.intValue());
        }
        if (encoding != null) {
            upload.setHeaderEncoding(encoding);
        }
        return upload;
    }
}

