/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.startup;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import net.hasor.core.AppContext;
import net.hasor.core.Hasor;
import net.hasor.core.context.AbstractAppContext;
import net.hasor.web.binder.SessionListenerPipeline;
import net.hasor.web.context.AnnoWebAppContext;
import org.more.util.ContextClassLoaderLocal;

public class RuntimeListener
implements ServletContextListener,
HttpSessionListener {
    public static final String AppContextName = AppContext.class.getName();
    private AbstractAppContext appContext = null;
    private SessionListenerPipeline sessionListenerPipeline = null;
    private static ContextClassLoaderLocal<ServletContext> LocalServletContext = new ContextClassLoaderLocal();
    private static ContextClassLoaderLocal<AppContext> LocalAppContext = new ContextClassLoaderLocal();

    protected AbstractAppContext createAppContext(ServletContext sc) throws Throwable {
        return new AnnoWebAppContext("hasor-config.xml", sc);
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            this.appContext = this.createAppContext(servletContextEvent.getServletContext());
            this.appContext.start();
            LocalServletContext.set((Object)servletContextEvent.getServletContext());
            LocalAppContext.set((Object)this.appContext);
        }
        catch (Throwable e) {
            Hasor.logError((String)"createAppContext error.\n%s", (Object[])new Object[]{e});
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        this.sessionListenerPipeline = (SessionListenerPipeline)this.appContext.getInstance(SessionListenerPipeline.class);
        this.sessionListenerPipeline.init((AppContext)this.appContext);
        Hasor.logInfo((String)"sessionListenerPipeline created.", (Object[])new Object[0]);
        Hasor.logInfo((String)("ServletContext Attribut : " + AppContextName + " -->> " + Hasor.logString((Object)this.appContext)), (Object[])new Object[0]);
        servletContextEvent.getServletContext().setAttribute(AppContextName, (Object)this.appContext);
        this.sessionListenerPipeline.contextInitialized(servletContextEvent);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        this.sessionListenerPipeline.contextDestroyed(servletContextEvent);
        this.appContext.stop();
    }

    public void sessionCreated(HttpSessionEvent se) {
        this.sessionListenerPipeline.sessionCreated(se);
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        this.sessionListenerPipeline.sessionDestroyed(se);
    }

    public static ServletContext getLocalServletContext() {
        return (ServletContext)LocalServletContext.get();
    }

    public static AppContext getLocalAppContext() {
        return (AppContext)LocalAppContext.get();
    }
}

