/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.startup;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.AppContext;
import net.hasor.core.Hasor;
import net.hasor.web.binder.FilterPipeline;
import net.hasor.web.startup.RuntimeListener;

@Singleton
public class RuntimeFilter
implements Filter {
    @Inject
    private AppContext appContext = null;
    @Inject
    private FilterPipeline filterPipeline = null;
    private String requestEncoding = null;
    private String responseEncoding = null;
    private static ThreadLocal<HttpServletRequest> LocalRequest = new ThreadLocal();
    private static ThreadLocal<HttpServletResponse> LocalResponse = new ThreadLocal();

    public synchronized void init(FilterConfig filterConfig) throws ServletException {
        if (this.appContext == null) {
            ServletContext servletContext = filterConfig.getServletContext();
            this.appContext = (AppContext)servletContext.getAttribute(RuntimeListener.AppContextName);
            Hasor.assertIsNotNull((Object)this.appContext, (String)"AppContext is null.");
            this.filterPipeline = (FilterPipeline)this.appContext.getInstance(FilterPipeline.class);
        }
        this.requestEncoding = this.appContext.getSettings().getString("hasor-web.encoding.requestEncoding");
        this.responseEncoding = this.appContext.getSettings().getString("hasor-web.encoding.responseEncoding");
        this.filterPipeline.initPipeline(this.appContext);
        Hasor.logInfo((String)"PlatformFilter started.", (Object[])new Object[0]);
    }

    public void destroy() {
        Hasor.logInfo((String)"executeCycle destroyCycle.", (Object[])new Object[0]);
        if (this.filterPipeline != null) {
            this.filterPipeline.destroyPipeline(this.appContext);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq = (HttpServletRequest)request;
        HttpServletResponse httpRes = (HttpServletResponse)response;
        if (this.requestEncoding != null) {
            httpReq.setCharacterEncoding(this.requestEncoding);
        }
        if (this.requestEncoding != null) {
            httpRes.setCharacterEncoding(this.responseEncoding);
        }
        Hasor.logDebug((String)"at http(%s/%s) request : %s", (Object[])new Object[]{this.requestEncoding, this.responseEncoding, httpReq.getRequestURI()});
        try {
            this.beforeRequest(this.appContext, httpReq, httpRes);
            this.processFilterPipeline(httpReq, httpRes, chain);
        }
        catch (IOException e) {
            Hasor.logWarn((String)"execFilterPipeline IOException %s.", (Object[])new Object[]{e});
            throw e;
        }
        catch (ServletException e) {
            Hasor.logWarn((String)"execFilterPipeline ServletException %s.", (Object[])new Object[]{e.getCause()});
            throw e;
        }
        finally {
            this.afterResponse(this.appContext, httpReq, httpRes);
        }
    }

    private void processFilterPipeline(HttpServletRequest httpReq, HttpServletResponse httpRes, FilterChain chain) throws IOException, ServletException {
        this.filterPipeline.dispatch(httpReq, httpRes, chain);
    }

    protected final AppContext getAppContext() {
        return RuntimeListener.getLocalAppContext();
    }

    protected void beforeRequest(AppContext appContext, HttpServletRequest httpReq, HttpServletResponse httpRes) {
        LocalRequest.set(httpReq);
        LocalResponse.set(httpRes);
    }

    protected void afterResponse(AppContext appContext, HttpServletRequest httpReq, HttpServletResponse httpRes) {
        LocalRequest.remove();
        LocalResponse.remove();
    }

    public static HttpServletRequest getLocalRequest() {
        return LocalRequest.get();
    }

    public static HttpServletResponse getLocalResponse() {
        return LocalResponse.get();
    }

    public static ServletContext getLocalServletContext() {
        return RuntimeListener.getLocalServletContext();
    }

    public static AppContext getLocalAppContext() {
        return RuntimeListener.getLocalAppContext();
    }
}

