/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.jstl.tagfun;

import com.google.inject.Provider;
import net.hasor.core.AppContext;
import net.hasor.web.startup.RuntimeListener;
import org.more.util.StringUtils;

public class Functions {
    protected static AppContext getAppContext() {
        AppContext appContext = RuntimeListener.getLocalAppContext();
        if (appContext != null) {
            return appContext;
        }
        throw new NullPointerException("AppContext is undefined.");
    }

    public static Object defineBean(String defineBean) {
        if (StringUtils.isBlank((String)defineBean)) {
            return null;
        }
        return Functions.getAppContext().getBean(defineBean);
    }

    public static Object defineType(String className) throws ClassNotFoundException {
        Class<?> defineType = Class.forName(className);
        return Functions.getAppContext().getInstance(defineType);
    }

    public static Object defineBinding(String name, String bindingType) throws ClassNotFoundException {
        if (StringUtils.isBlank((String)name)) {
            return null;
        }
        if (StringUtils.isBlank((String)bindingType)) {
            return null;
        }
        Class<?> defineType = Class.forName(bindingType);
        Provider provider = Functions.getAppContext().findProviderByType(name, defineType);
        if (provider != null) {
            return provider.get();
        }
        return null;
    }

    public static boolean hasBean(String defineBean) {
        String[] names;
        if (StringUtils.isBlank((String)defineBean)) {
            return false;
        }
        for (String ns : names = Functions.getAppContext().getBeanNames()) {
            if (!ns.equals(defineBean)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasBinding(String name, String className) throws ClassNotFoundException {
        if (StringUtils.isBlank((String)name)) {
            return false;
        }
        Class<?> defineType = Class.forName(className);
        Provider provider = Functions.getAppContext().findProviderByType(name, defineType);
        return provider != null;
    }
}

