/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.env;

import java.io.File;
import java.net.URI;
import java.util.Map;
import javax.servlet.ServletContext;
import net.hasor.core.environment.AbstractEnvironment;
import net.hasor.core.environment.StandardEnvironment;
import net.hasor.web.WebEnvironment;

public class WebStandardEnvironment
extends StandardEnvironment
implements WebEnvironment {
    private ServletContext servletContext;

    public WebStandardEnvironment(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.initEnvironment();
    }

    public WebStandardEnvironment(URI settingURI, ServletContext servletContext) {
        this.settingURI = settingURI;
        this.servletContext = servletContext;
        this.initEnvironment();
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    protected AbstractEnvironment.EnvVars createEnvVars() {
        final WebStandardEnvironment $this = this;
        return new AbstractEnvironment.EnvVars((AbstractEnvironment)this){

            protected Map<String, String> configEnvironment() {
                Map hasorEnv = super.configEnvironment();
                String webContextDir = WebStandardEnvironment.this.servletContext.getRealPath("/");
                hasorEnv.put("HASOR_WEBROOT", webContextDir);
                String workDir = $this.getSettings().getString("environmentVar.HASOR_WORK_HOME", "./");
                workDir = workDir.replace("/", File.separator);
                if (workDir.startsWith("." + File.separatorChar)) {
                    hasorEnv.put("HASOR_WORK_HOME", new File(webContextDir, workDir.substring(2)).getAbsolutePath());
                }
                return hasorEnv;
            }
        };
    }
}

