/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.context;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.hasor.core.ApiBinder;
import net.hasor.core.binder.AbstractApiBinder;
import net.hasor.core.context.AnnoStandardAppContext;
import net.hasor.core.module.ModulePropxy;
import net.hasor.web.WebAppContext;
import net.hasor.web.WebEnvironment;
import net.hasor.web.binder.FilterPipeline;
import net.hasor.web.binder.SessionListenerPipeline;
import net.hasor.web.binder.support.ManagedFilterPipeline;
import net.hasor.web.binder.support.ManagedServletPipeline;
import net.hasor.web.binder.support.ManagedSessionListenerPipeline;
import net.hasor.web.binder.support.WebApiBinderModule;
import net.hasor.web.env.WebStandardEnvironment;
import net.hasor.web.startup.RuntimeFilter;

public class AnnoWebAppContext
extends AnnoStandardAppContext
implements WebAppContext {
    public AnnoWebAppContext(ServletContext servletContext) throws IOException, URISyntaxException {
        this((String)null, servletContext);
    }

    public AnnoWebAppContext(String mainSettings, ServletContext servletContext) throws IOException, URISyntaxException {
        super(mainSettings, (Object)servletContext);
    }

    public AnnoWebAppContext(File mainSettings, ServletContext servletContext) {
        super(mainSettings, (Object)servletContext);
    }

    public AnnoWebAppContext(URI mainSettings, ServletContext servletContext) {
        super(mainSettings, (Object)servletContext);
    }

    @Override
    public ServletContext getServletContext() {
        return ((WebEnvironment)this.getEnvironment()).getServletContext();
    }

    protected Injector createInjector(Module[] guiceModules) {
        Module webModule = new Module(){

            public void configure(Binder guiceBinder) {
                guiceBinder.bind(ManagedServletPipeline.class).asEagerSingleton();
                guiceBinder.bind(FilterPipeline.class).to(ManagedFilterPipeline.class).asEagerSingleton();
                guiceBinder.bind(SessionListenerPipeline.class).to(ManagedSessionListenerPipeline.class).asEagerSingleton();
            }
        };
        ArrayList<Module> guiceModuleSet = new ArrayList<Module>();
        if (guiceModules != null) {
            guiceModuleSet.addAll(Arrays.asList(guiceModules));
        }
        guiceModuleSet.add(webModule);
        return super.createInjector(guiceModuleSet.toArray(new Module[guiceModuleSet.size()]));
    }

    protected WebEnvironment createEnvironment() {
        return new WebStandardEnvironment(this.getMainSettings(), (ServletContext)this.getContext());
    }

    protected AbstractApiBinder newApiBinder(final ModulePropxy forModule, final Binder guiceBinder) {
        return new WebApiBinderModule((WebEnvironment)this.getEnvironment()){

            public ApiBinder.ModuleSettings configModule() {
                return forModule;
            }

            public Binder getGuiceBinder() {
                return guiceBinder;
            }
        };
    }

    protected void doBind(Binder guiceBinder) {
        super.doBind(guiceBinder);
        guiceBinder.bind(ServletRequest.class).toProvider((Provider)new Provider<ServletRequest>(){

            public ServletRequest get() {
                return RuntimeFilter.getLocalRequest();
            }
        });
        guiceBinder.bind(HttpServletRequest.class).toProvider((Provider)new Provider<HttpServletRequest>(){

            public HttpServletRequest get() {
                return RuntimeFilter.getLocalRequest();
            }
        });
        guiceBinder.bind(ServletResponse.class).toProvider((Provider)new Provider<ServletResponse>(){

            public ServletResponse get() {
                return RuntimeFilter.getLocalResponse();
            }
        });
        guiceBinder.bind(HttpServletResponse.class).toProvider((Provider)new Provider<HttpServletResponse>(){

            public HttpServletResponse get() {
                return RuntimeFilter.getLocalResponse();
            }
        });
        guiceBinder.bind(HttpSession.class).toProvider((Provider)new Provider<HttpSession>(){

            public HttpSession get() {
                HttpServletRequest req = RuntimeFilter.getLocalRequest();
                return req != null ? req.getSession(true) : null;
            }
        });
        guiceBinder.bind(ServletContext.class).toProvider((Provider)new Provider<ServletContext>(){

            public ServletContext get() {
                return AnnoWebAppContext.this.getServletContext();
            }
        });
    }
}

