/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.binder.support;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.internal.UniqueAnnotations;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import net.hasor.web.WebApiBinder;
import net.hasor.web.binder.support.ServletDefinition;
import net.hasor.web.binder.support.UriPatternType;

class ServletsModuleBuilder
implements Module {
    private final List<ServletDefinition> servletDefinitions = new ArrayList<ServletDefinition>();

    ServletsModuleBuilder() {
    }

    public WebApiBinder.ServletBindingBuilder filterPattern(List<String> servletPattern) {
        return new ServletBindingBuilderImpl(UriPatternType.SERVLET, servletPattern);
    }

    public WebApiBinder.ServletBindingBuilder filterRegex(List<String> regexPattern) {
        return new ServletBindingBuilderImpl(UriPatternType.REGEX, regexPattern);
    }

    public void configure(Binder binder) {
        for (ServletDefinition define : this.servletDefinitions) {
            binder.bind(ServletDefinition.class).annotatedWith(UniqueAnnotations.create()).toProvider((Provider)define);
        }
    }

    class ServletBindingBuilderImpl
    implements WebApiBinder.ServletBindingBuilder {
        private final List<String> uriPatterns;
        private final UriPatternType uriPatternType;

        public ServletBindingBuilderImpl(UriPatternType uriPatternType, List<String> uriPatterns) {
            this.uriPatterns = uriPatterns;
            this.uriPatternType = uriPatternType;
        }

        @Override
        public void with(Class<? extends HttpServlet> servletKey) {
            this.with(0, (Key<? extends HttpServlet>)Key.get(servletKey));
        }

        @Override
        public void with(Key<? extends HttpServlet> servletKey) {
            this.with(0, servletKey, new HashMap<String, String>());
        }

        @Override
        public void with(HttpServlet servlet) {
            this.with(0, servlet, new HashMap<String, String>());
        }

        @Override
        public void with(Class<? extends HttpServlet> servletKey, Map<String, String> initParams) {
            this.with(0, (Key<? extends HttpServlet>)Key.get(servletKey), initParams);
        }

        @Override
        public void with(Key<? extends HttpServlet> servletKey, Map<String, String> initParams) {
            this.with(0, servletKey, initParams, null);
        }

        @Override
        public void with(HttpServlet servlet, Map<String, String> initParams) {
            Key servletKey = Key.get(HttpServlet.class, (Annotation)UniqueAnnotations.create());
            this.with(0, (Key<? extends HttpServlet>)servletKey, initParams, servlet);
        }

        @Override
        public void with(int index, Class<? extends HttpServlet> servletKey) {
            this.with(index, (Key<? extends HttpServlet>)Key.get(servletKey));
        }

        @Override
        public void with(int index, Key<? extends HttpServlet> servletKey) {
            this.with(index, servletKey, new HashMap<String, String>());
        }

        @Override
        public void with(int index, HttpServlet servlet) {
            this.with(index, servlet, new HashMap<String, String>());
        }

        @Override
        public void with(int index, Class<? extends HttpServlet> servletKey, Map<String, String> initParams) {
            this.with(index, (Key<? extends HttpServlet>)Key.get(servletKey), initParams);
        }

        @Override
        public void with(int index, Key<? extends HttpServlet> servletKey, Map<String, String> initParams) {
            this.with(index, servletKey, initParams, null);
        }

        @Override
        public void with(int index, HttpServlet servlet, Map<String, String> initParams) {
            Key servletKey = Key.get(HttpServlet.class, (Annotation)UniqueAnnotations.create());
            this.with(index, (Key<? extends HttpServlet>)servletKey, initParams, servlet);
        }

        private void with(int index, Key<? extends HttpServlet> servletKey, Map<String, String> initParams, HttpServlet servletInstance) {
            for (String pattern : this.uriPatterns) {
                ServletsModuleBuilder.this.servletDefinitions.add(new ServletDefinition(index, pattern, servletKey, UriPatternType.get(this.uriPatternType, pattern), initParams, servletInstance));
            }
        }
    }
}

