/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.binder.support;

import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.AppContext;
import net.hasor.web.binder.FilterPipeline;
import net.hasor.web.binder.support.FilterChainInvocation;
import net.hasor.web.binder.support.FilterDefinition;
import net.hasor.web.binder.support.ManagedServletPipeline;

public class ManagedFilterPipeline
implements FilterPipeline {
    private final ManagedServletPipeline servletPipeline;
    private FilterDefinition[] filterDefinitions;
    private volatile boolean initialized = false;
    private AppContext appContext = null;

    @Inject
    public ManagedFilterPipeline(ManagedServletPipeline servletPipeline) {
        this.servletPipeline = servletPipeline;
    }

    @Override
    public synchronized void initPipeline(AppContext appContext) throws ServletException {
        if (this.initialized) {
            return;
        }
        this.appContext = appContext;
        for (FilterDefinition filterDefinition : this.filterDefinitions = this.collectFilterDefinitions(appContext.getGuice())) {
            filterDefinition.init(appContext);
        }
        this.servletPipeline.initPipeline(appContext);
        this.initialized = true;
    }

    private FilterDefinition[] collectFilterDefinitions(Injector injector) {
        ArrayList<Object> filterDefinitions = new ArrayList<Object>();
        TypeLiteral FILTER_DEFS = TypeLiteral.get(FilterDefinition.class);
        for (Binding entry : injector.findBindingsByType(FILTER_DEFS)) {
            filterDefinitions.add(entry.getProvider().get());
        }
        Collections.sort(filterDefinitions, new Comparator<FilterDefinition>(){

            @Override
            public int compare(FilterDefinition o1, FilterDefinition o2) {
                int o2Index;
                int o1Index = o1.getIndex();
                return o1Index < (o2Index = o2.getIndex()) ? -1 : (o1Index == o2Index ? 0 : 1);
            }
        });
        return filterDefinitions.toArray(new FilterDefinition[filterDefinitions.size()]);
    }

    @Override
    public void dispatch(HttpServletRequest request, HttpServletResponse response, FilterChain defaultFilterChain) throws IOException, ServletException {
        if (!this.initialized) {
            this.initPipeline(this.appContext);
        }
        ServletRequest dispatcherRequest = this.withDispatcher((ServletRequest)request, this.servletPipeline);
        new FilterChainInvocation(this.filterDefinitions, this.servletPipeline, defaultFilterChain).doFilter(dispatcherRequest, (ServletResponse)response);
    }

    @Override
    public void destroyPipeline(AppContext appContext) {
        this.servletPipeline.destroyPipeline(appContext);
        for (FilterDefinition filterDefinition : this.filterDefinitions) {
            filterDefinition.destroy(appContext);
        }
    }

    private ServletRequest withDispatcher(ServletRequest servletRequest, final ManagedServletPipeline servletPipeline) {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (!servletPipeline.hasServletsMapped()) {
            return servletRequest;
        }
        return new HttpServletRequestWrapper(request){

            public RequestDispatcher getRequestDispatcher(String path) {
                RequestDispatcher dispatcher = servletPipeline.getRequestDispatcher(path);
                return null != dispatcher ? dispatcher : super.getRequestDispatcher(path);
            }
        };
    }
}

