/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.binder.support;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.internal.UniqueAnnotations;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import net.hasor.web.WebApiBinder;
import net.hasor.web.binder.support.FilterDefinition;
import net.hasor.web.binder.support.UriPatternType;

class FiltersModuleBuilder
implements Module {
    private final List<FilterDefinition> filterDefinitions = new ArrayList<FilterDefinition>();

    FiltersModuleBuilder() {
    }

    public WebApiBinder.FilterBindingBuilder filterPattern(List<String> servletPattern) {
        return new FilterBindingBuilderImpl(UriPatternType.SERVLET, servletPattern);
    }

    public WebApiBinder.FilterBindingBuilder filterRegex(List<String> regexPattern) {
        return new FilterBindingBuilderImpl(UriPatternType.REGEX, regexPattern);
    }

    public void configure(Binder binder) {
        for (FilterDefinition define : this.filterDefinitions) {
            binder.bind(FilterDefinition.class).annotatedWith(UniqueAnnotations.create()).toProvider((Provider)define);
        }
    }

    class FilterBindingBuilderImpl
    implements WebApiBinder.FilterBindingBuilder {
        private final UriPatternType uriPatternType;
        private final List<String> uriPatterns;

        public FilterBindingBuilderImpl(UriPatternType uriPatternType, List<String> uriPatterns) {
            this.uriPatternType = uriPatternType;
            this.uriPatterns = uriPatterns;
        }

        @Override
        public void through(Class<? extends Filter> filterKey) {
            this.through(0, (Key<? extends Filter>)Key.get(filterKey));
        }

        @Override
        public void through(Key<? extends Filter> filterKey) {
            this.through(0, filterKey, new HashMap<String, String>());
        }

        @Override
        public void through(Filter filter) {
            this.through(0, filter, new HashMap<String, String>());
        }

        @Override
        public void through(Class<? extends Filter> filterKey, Map<String, String> initParams) {
            this.through(0, (Key<? extends Filter>)Key.get(filterKey), initParams);
        }

        @Override
        public void through(Key<? extends Filter> filterKey, Map<String, String> initParams) {
            this.through(0, filterKey, initParams, null);
        }

        @Override
        public void through(Filter filter, Map<String, String> initParams) {
            Key filterKey = Key.get(Filter.class, (Annotation)UniqueAnnotations.create());
            this.through(0, (Key<? extends Filter>)filterKey, initParams, filter);
        }

        @Override
        public void through(int index, Class<? extends Filter> filterKey) {
            this.through(index, (Key<? extends Filter>)Key.get(filterKey));
        }

        @Override
        public void through(int index, Key<? extends Filter> filterKey) {
            this.through(index, filterKey, new HashMap<String, String>());
        }

        @Override
        public void through(int index, Filter filter) {
            this.through(index, filter, new HashMap<String, String>());
        }

        @Override
        public void through(int index, Class<? extends Filter> filterKey, Map<String, String> initParams) {
            this.through(index, (Key<? extends Filter>)Key.get(filterKey), initParams);
        }

        @Override
        public void through(int index, Key<? extends Filter> filterKey, Map<String, String> initParams) {
            this.through(index, filterKey, initParams, null);
        }

        @Override
        public void through(int index, Filter filter, Map<String, String> initParams) {
            Key filterKey = Key.get(Filter.class, (Annotation)UniqueAnnotations.create());
            this.through(index, (Key<? extends Filter>)filterKey, initParams, filter);
        }

        private void through(int index, Key<? extends Filter> filterKey, Map<String, String> initParams, Filter filterInstance) {
            for (String pattern : this.uriPatterns) {
                FiltersModuleBuilder.this.filterDefinitions.add(new FilterDefinition(index, pattern, filterKey, UriPatternType.get(this.uriPatternType, pattern), initParams, filterInstance));
            }
        }
    }
}

