/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.binder.support;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import net.hasor.core.AppContext;

class ContextListenerDefinition
implements Provider<ContextListenerDefinition> {
    private Key<? extends ServletContextListener> listenerKey = null;
    private ServletContextListener listenerInstance = null;

    public ContextListenerDefinition(Key<? extends ServletContextListener> listenerKey, ServletContextListener listenerInstance) {
        this.listenerKey = listenerKey;
        this.listenerInstance = listenerInstance;
    }

    public ContextListenerDefinition get() {
        return this;
    }

    protected ServletContextListener getTarget(Injector injector) {
        if (this.listenerInstance == null) {
            this.listenerInstance = (ServletContextListener)injector.getInstance(this.listenerKey);
        }
        return this.listenerInstance;
    }

    public String toString() {
        return String.format("type %s listenerKey=%s", ContextListenerDefinition.class, this.listenerKey);
    }

    public void contextInitialized(AppContext appContext, ServletContextEvent event) {
        ServletContextListener servletContextListener = this.getTarget(appContext.getGuice());
        if (servletContextListener != null) {
            servletContextListener.contextInitialized(event);
        }
    }

    public void contextDestroyed(AppContext appContext, ServletContextEvent event) {
        ServletContextListener servletContextListener = this.getTarget(appContext.getGuice());
        if (servletContextListener != null) {
            servletContextListener.contextDestroyed(event);
        }
    }
}

