/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.servlet3;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.http.HttpServlet;
import net.hasor.core.Hasor;
import net.hasor.core.plugin.Plugin;
import net.hasor.plugins.servlet3.WebFilter;
import net.hasor.plugins.servlet3.WebInitParam;
import net.hasor.plugins.servlet3.WebServlet;
import net.hasor.web.WebApiBinder;
import net.hasor.web.plugin.AbstractWebHasorPlugin;
import org.more.util.StringUtils;

@Plugin
public class JavaEEPlugin
extends AbstractWebHasorPlugin {
    @Override
    public void loadPlugin(WebApiBinder webBinder) {
        if (!(webBinder instanceof WebApiBinder)) {
            return;
        }
        this.loadFilter(webBinder);
        this.loadServlet(webBinder);
    }

    protected void loadFilter(WebApiBinder apiBinder) {
        Set webFilterSet = apiBinder.findClass(WebFilter.class);
        if (webFilterSet == null) {
            return;
        }
        ArrayList<Class> webFilterList = new ArrayList<Class>();
        for (Class cls : webFilterSet) {
            if (!Filter.class.isAssignableFrom(cls)) {
                Hasor.logWarn((String)"not implemented Filter :%s", (Object[])new Object[]{cls});
                continue;
            }
            webFilterList.add(cls);
        }
        for (Class filterType : webFilterList) {
            WebFilter filterAnno = filterType.getAnnotation(WebFilter.class);
            Map<String, String> initMap = this.toMap(filterAnno.initParams());
            apiBinder.filter(null, filterAnno.value()).through(filterAnno.sort(), filterType, initMap);
            String filterName = StringUtils.isBlank((String)filterAnno.filterName()) ? filterType.getSimpleName() : filterAnno.filterName();
            Hasor.logInfo((String)"loadFilter %s[%s] bind %s on %s.", (Object[])new Object[]{filterName, JavaEEPlugin.getIndexStr(filterAnno.sort()), filterType, filterAnno.value()});
        }
    }

    protected void loadServlet(WebApiBinder apiBinder) {
        Set webServletSet = apiBinder.findClass(WebServlet.class);
        if (webServletSet == null) {
            return;
        }
        ArrayList<Class> webServletList = new ArrayList<Class>();
        for (Class cls : webServletSet) {
            if (!HttpServlet.class.isAssignableFrom(cls)) {
                Hasor.logWarn((String)"not implemented HttpServlet :%s", (Object[])new Object[]{cls});
                continue;
            }
            webServletList.add(cls);
        }
        for (Class servletType : webServletList) {
            WebServlet servletAnno = servletType.getAnnotation(WebServlet.class);
            Map<String, String> initMap = this.toMap(servletAnno.initParams());
            String servletName = StringUtils.isBlank((String)servletAnno.servletName()) ? servletType.getSimpleName() : servletAnno.servletName();
            int sortInt = servletAnno.loadOnStartup();
            apiBinder.serve(null, servletAnno.value()).with(sortInt, servletType, initMap);
            Hasor.logInfo((String)"loadServlet %s[%s] bind %s on %s.", (Object[])new Object[]{servletName, JavaEEPlugin.getIndexStr(sortInt), servletType, servletAnno.value()});
        }
    }

    protected Map<String, String> toMap(WebInitParam[] initParams) {
        HashMap<String, String> initMap = new HashMap<String, String>();
        if (initParams != null) {
            for (WebInitParam param : initParams) {
                if (StringUtils.isBlank((String)param.name())) continue;
                initMap.put(param.name(), param.value());
            }
        }
        return initMap;
    }

    private static String getIndexStr(int index) {
        int allRange = 1000;
        int minStartIndex = Integer.MIN_VALUE;
        int minStopIndex = Integer.MIN_VALUE + allRange;
        for (int i = minStartIndex; i < minStopIndex; ++i) {
            if (index != i) continue;
            return "Min" + (index == Integer.MIN_VALUE ? "" : "+" + String.valueOf(i + Math.abs(Integer.MIN_VALUE)));
        }
        int maxStartIndex = Integer.MAX_VALUE;
        int maxStopIndex = Integer.MAX_VALUE - allRange;
        for (int i = maxStartIndex; i > maxStopIndex; --i) {
            if (index != i) continue;
            return "Max" + (index == Integer.MAX_VALUE ? "" : "-" + Math.abs(Integer.MAX_VALUE - i));
        }
        return String.valueOf(index);
    }
}

