/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.result;

import com.google.inject.matcher.Matcher;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Set;
import net.hasor.core.Hasor;
import net.hasor.core.plugin.Plugin;
import net.hasor.plugins.aop.matchers.AopMatchers;
import net.hasor.plugins.controller.AbstractController;
import net.hasor.plugins.controller.Controller;
import net.hasor.plugins.restful.RestfulService;
import net.hasor.plugins.result.ResultCaller_Controller;
import net.hasor.plugins.result.ResultCaller_Restful;
import net.hasor.plugins.result.ResultDefine;
import net.hasor.plugins.result.ResultProcess;
import net.hasor.web.WebApiBinder;
import net.hasor.web.plugin.AbstractWebHasorPlugin;
import org.aopalliance.intercept.MethodInterceptor;

@Plugin
public class ResultPlugin
extends AbstractWebHasorPlugin {
    @Override
    public void loadPlugin(WebApiBinder apiBinder) {
        HashMap defineMap = new HashMap();
        Set resultDefineSet = apiBinder.findClass(ResultDefine.class);
        if (resultDefineSet == null) {
            return;
        }
        for (Class resultDefineType : resultDefineSet) {
            if (!ResultProcess.class.isAssignableFrom(resultDefineType)) {
                Hasor.logWarn((String)"loadResultDefine : not implemented ResultProcess. class=%s", (Object[])new Object[]{resultDefineType});
                continue;
            }
            ResultDefine resultDefineAnno = resultDefineType.getAnnotation(ResultDefine.class);
            Class defineType = resultDefineType;
            Class<? extends Annotation> resultType = resultDefineAnno.value();
            Hasor.logInfo((String)"loadResultDefine annoType is %s toInstance %s", (Object[])new Object[]{resultType, resultDefineType});
            defineMap.put(resultType, defineType);
        }
        Matcher matcherController = AopMatchers.subclassesOf(AbstractController.class).and(AopMatchers.annotatedWith(Controller.class));
        ResultCaller_Controller caller_1 = new ResultCaller_Controller(apiBinder, defineMap);
        apiBinder.getGuiceBinder().bindInterceptor(matcherController, AopMatchers.any(), new MethodInterceptor[]{caller_1});
        ResultCaller_Restful caller_2 = new ResultCaller_Restful(apiBinder, defineMap);
        apiBinder.getGuiceBinder().bindInterceptor(AopMatchers.annotatedWith(RestfulService.class), AopMatchers.any(), new MethodInterceptor[]{caller_2});
    }
}

