/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.restful.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.Hasor;
import net.hasor.plugins.restful.AttributeParam;
import net.hasor.plugins.restful.CookieParam;
import net.hasor.plugins.restful.HeaderParam;
import net.hasor.plugins.restful.PathParam;
import net.hasor.plugins.restful.QueryParam;
import net.hasor.plugins.restful.support.RestfulInvokeDefine;
import org.more.convert.ConverterUtils;
import org.more.util.BeanUtils;
import org.more.util.StringUtils;

public class RestfulInvoke {
    private HttpServletRequest requestLocal;
    private HttpServletResponse responseLocal;
    private RestfulInvokeDefine define;
    private Object targetObject;
    private static ThreadLocal<Stack<RestfulInvoke>> LocalStack = new ThreadLocal();
    private Map<String, List<String>> queryParamLocal;
    private Map<String, Object> pathParamsLocal;

    public static RestfulInvoke currentRestfulInvoke() {
        Stack<RestfulInvoke> stack = RestfulInvoke.getLocalStack();
        if (!stack.isEmpty()) {
            return stack.peek();
        }
        return null;
    }

    private static Stack<RestfulInvoke> getLocalStack() {
        Stack<RestfulInvoke> localStack = LocalStack.get();
        if (localStack == null) {
            localStack = new Stack();
            LocalStack.set(localStack);
        }
        return localStack;
    }

    protected RestfulInvoke(RestfulInvokeDefine define) {
        this.define = define;
    }

    public Object getTargetObject() {
        if (this.targetObject != null) {
            return this.targetObject;
        }
        this.targetObject = this.define.getAppContext().getInstance(this.define.getTargetClass());
        return this.targetObject;
    }

    public HttpServletRequest getRequest() {
        return this.requestLocal;
    }

    public HttpServletResponse getResponse() {
        return this.responseLocal;
    }

    public RestfulInvokeDefine getDefine() {
        return this.define;
    }

    public void initHttp(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.requestLocal = httpRequest;
        this.responseLocal = httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invoke() throws Throwable {
        try {
            RestfulInvoke.getLocalStack().push(this);
            String produces = this.define.getProduces();
            if (!StringUtils.isBlank((String)produces)) {
                this.getResponse().setContentType(produces);
            }
            Object targetObject = this.getTargetObject();
            Object[] invokeParams = this.prepareParams();
            Object object = this.define.getTargetMethod().invoke(targetObject, invokeParams);
            return object;
        }
        finally {
            RestfulInvoke.getLocalStack().pop();
        }
    }

    public Object[] prepareParams() throws Throwable {
        Method targetMethod = this.define.getTargetMethod();
        Class<?>[] targetParamClass = targetMethod.getParameterTypes();
        Annotation[][] targetParamAnno = targetMethod.getParameterAnnotations();
        targetParamClass = targetParamClass == null ? new Class[]{} : targetParamClass;
        targetParamAnno = targetParamAnno == null ? new Annotation[0][0] : targetParamAnno;
        ArrayList<Object> paramsArray = new ArrayList<Object>();
        for (int i = 0; i < targetParamClass.length; ++i) {
            Class<?> paramClass = targetParamClass[i];
            Object paramObject = this.getIvnokeParams(paramClass, targetParamAnno[i]);
            paramObject = paramObject == null ? BeanUtils.getDefaultValue(paramClass) : ConverterUtils.convert(paramClass, (Object)paramObject);
            paramsArray.add(paramObject);
        }
        Object[] invokeParams = paramsArray.toArray();
        return invokeParams;
    }

    protected Object invoke(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Throwable {
        this.initHttp(httpRequest, httpResponse);
        return this.invoke();
    }

    public Object[] prepareParams(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Throwable {
        this.initHttp(httpRequest, httpResponse);
        return this.prepareParams();
    }

    private Object getIvnokeParams(Class<?> paramClass, Annotation[] paramAnno) {
        for (Annotation pAnno : paramAnno) {
            if (pAnno instanceof AttributeParam) {
                return this.getAttributeParam(paramClass, (AttributeParam)pAnno);
            }
            if (pAnno instanceof CookieParam) {
                return this.getCookieParam(paramClass, (CookieParam)pAnno);
            }
            if (pAnno instanceof HeaderParam) {
                return this.getHeaderParam(paramClass, (HeaderParam)pAnno);
            }
            if (pAnno instanceof QueryParam) {
                return this.getQueryParam(paramClass, (QueryParam)pAnno);
            }
            if (!(pAnno instanceof PathParam)) continue;
            return this.getPathParam(paramClass, (PathParam)pAnno);
        }
        return BeanUtils.getDefaultValue(paramClass);
    }

    private Object getPathParam(Class<?> paramClass, PathParam pAnno) {
        String paramName = pAnno.value();
        return StringUtils.isBlank((String)paramName) ? null : this.getPathParamMap().get(paramName);
    }

    private Object getQueryParam(Class<?> paramClass, QueryParam pAnno) {
        String paramName = pAnno.value();
        return StringUtils.isBlank((String)paramName) ? null : this.getQueryParamMap().get(paramName);
    }

    private Object getHeaderParam(Class<?> paramClass, HeaderParam pAnno) {
        String paramName = pAnno.value();
        if (StringUtils.isBlank((String)paramName)) {
            return null;
        }
        HttpServletRequest httpRequest = this.getRequest();
        Enumeration e = httpRequest.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement().toString();
            if (!StringUtils.equalsIgnoreCase((String)name, (String)paramName)) continue;
            ArrayList headerList = new ArrayList();
            Enumeration v = httpRequest.getHeaders(paramName);
            while (v.hasMoreElements()) {
                headerList.add(v.nextElement());
            }
            return headerList;
        }
        return null;
    }

    private Object getCookieParam(Class<?> paramClass, CookieParam pAnno) {
        String paramName = pAnno.value();
        if (StringUtils.isBlank((String)paramName)) {
            return null;
        }
        HttpServletRequest httpRequest = this.getRequest();
        Cookie[] cookies = httpRequest.getCookies();
        ArrayList<String> cookieList = new ArrayList<String>();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!StringUtils.equalsIgnoreCase((String)cookie.getName(), (String)paramName)) continue;
                cookieList.add(cookie.getValue());
            }
        }
        return cookieList;
    }

    private Object getAttributeParam(Class<?> paramClass, AttributeParam pAnno) {
        String paramName = pAnno.value();
        if (StringUtils.isBlank((String)paramName)) {
            return null;
        }
        HttpServletRequest httpRequest = this.getRequest();
        Enumeration e = httpRequest.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement().toString();
            if (!StringUtils.equalsIgnoreCase((String)name, (String)paramName)) continue;
            return httpRequest.getAttribute(paramName);
        }
        return null;
    }

    private Map<String, List<String>> getQueryParamMap() {
        String[] params;
        if (this.queryParamLocal != null) {
            return this.queryParamLocal;
        }
        HttpServletRequest httpRequest = this.getRequest();
        String queryString = httpRequest.getQueryString();
        if (StringUtils.isBlank((String)queryString)) {
            return null;
        }
        this.queryParamLocal = new HashMap<String, List<String>>();
        for (String pData : params = queryString.split("&")) {
            String oriData = null;
            String encoding = httpRequest.getCharacterEncoding();
            try {
                oriData = URLDecoder.decode(pData, encoding);
            }
            catch (Exception e) {
                Hasor.logWarn((String)"use \u2018%s\u2019 decode \u2018%s\u2019 error.", (Object[])new Object[]{encoding, pData});
                continue;
            }
            String[] kv = oriData.split("=");
            if (kv.length < 2) continue;
            String k = kv[0].trim().toUpperCase();
            String v = kv[1];
            ArrayList<String> pArray = this.queryParamLocal.get(k);
            ArrayList<String> arrayList = pArray = pArray == null ? new ArrayList<String>() : pArray;
            if (!pArray.contains(v)) {
                pArray.add(v);
            }
            this.queryParamLocal.put(k, pArray);
        }
        return this.queryParamLocal;
    }

    private Map<String, Object> getPathParamMap() {
        if (this.pathParamsLocal != null) {
            return this.pathParamsLocal;
        }
        HttpServletRequest httpRequest = this.getRequest();
        String requestPath = httpRequest.getRequestURI().substring(httpRequest.getContextPath().length());
        String matchVar = this.define.getRestfulMappingMatches();
        String matchKey = "(?:\\{(\\w+)\\}){1,}";
        Matcher keyM = Pattern.compile(matchKey).matcher(this.define.getRestfulMapping());
        Matcher varM = Pattern.compile(matchVar).matcher(requestPath);
        ArrayList<String> keyArray = new ArrayList<String>();
        ArrayList<String> varArray = new ArrayList<String>();
        while (keyM.find()) {
            keyArray.add(keyM.group(1));
        }
        varM.find();
        for (int i = 1; i <= varM.groupCount(); ++i) {
            varArray.add(varM.group(i));
        }
        HashMap<String, List> uriParams = new HashMap<String, List>();
        for (int i = 0; i < keyArray.size(); ++i) {
            String k = (String)keyArray.get(i);
            String v = (String)varArray.get(i);
            List pArray = (List)uriParams.get(k);
            List list = pArray = pArray == null ? new ArrayList() : pArray;
            if (!pArray.contains(v)) {
                pArray.add(v);
            }
            uriParams.put(k, pArray);
        }
        this.pathParamsLocal = new HashMap<String, Object>();
        for (Map.Entry ent : uriParams.entrySet()) {
            String k = (String)ent.getKey();
            List v = (List)ent.getValue();
            this.pathParamsLocal.put(k, v.toArray(new String[v.size()]));
        }
        return this.pathParamsLocal;
    }
}

