/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.resource.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.hasor.plugins.resource.ResourceLoader;

public class PathResourceLoader
implements ResourceLoader {
    private String dirPath = null;

    public PathResourceLoader(String dirPath) {
        this.dirPath = dirPath;
    }

    private String formatResourcePath(String resourcePath) {
        String $resourcePath = this.dirPath + "/" + resourcePath;
        $resourcePath = $resourcePath.replaceAll("/{2}", "/");
        return $resourcePath;
    }

    @Override
    public InputStream getResourceAsStream(String resourcePath) {
        resourcePath = this.formatResourcePath(resourcePath);
        File file = new File(resourcePath);
        try {
            if (file.exists() && file.isFile()) {
                return new FileInputStream(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean canModify(String resourcePath) throws IOException {
        return true;
    }

    @Override
    public boolean exist(String resourcePath) throws IOException {
        File file = new File(resourcePath = this.formatResourcePath(resourcePath));
        return file.exists() && file.isFile();
    }

    @Override
    public void close(Object resource) throws IOException {
        if (resource == null) {
            return;
        }
        if (resource instanceof InputStream) {
            ((InputStream)resource).close();
        }
    }
}

