/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.resource.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.hasor.plugins.resource.ResourceLoader;
import org.more.util.StringUtils;

public class ClassPathResourceLoader
implements ResourceLoader {
    private String packageName = null;
    private ClassLoader classLoader = null;

    public ClassPathResourceLoader(String packageName) {
        this.packageName = packageName;
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public ClassPathResourceLoader(String packageName, ClassLoader classLoader) {
        this.packageName = packageName;
        this.classLoader = classLoader;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private String formatResourcePath(String resourcePath) {
        String $resourcePath = this.packageName + (resourcePath.charAt(0) == '/' ? resourcePath : "/" + resourcePath);
        if (($resourcePath = $resourcePath.replaceAll("/{2}", "/")).charAt(0) == '/') {
            $resourcePath = $resourcePath.substring(1);
        }
        return $resourcePath;
    }

    @Override
    public InputStream getResourceAsStream(String resourcePath) {
        if (StringUtils.isBlank((String)resourcePath)) {
            return null;
        }
        return this.classLoader.getResourceAsStream(this.formatResourcePath(resourcePath));
    }

    @Override
    public boolean canModify(String resourcePath) throws IOException {
        if (StringUtils.isBlank((String)resourcePath)) {
            return false;
        }
        URL url = this.classLoader.getResource(this.formatResourcePath(resourcePath));
        return url.getProtocol().contains("file");
    }

    @Override
    public boolean exist(String resourcePath) throws IOException {
        if (StringUtils.isBlank((String)resourcePath)) {
            return false;
        }
        URL url = this.classLoader.getResource(this.formatResourcePath(resourcePath));
        return url != null;
    }

    @Override
    public void close(Object resource) throws IOException {
        if (resource == null) {
            return;
        }
        if (resource instanceof InputStream) {
            ((InputStream)resource).close();
        }
    }
}

