/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.AppContext;
import net.hasor.core.Hasor;
import net.hasor.plugins.resource.ResourceLoader;
import net.hasor.plugins.resource.ResourceLoaderFactory;
import org.more.util.ContextClassLoaderLocal;
import org.more.util.FileUtils;
import org.more.util.IOUtils;
import org.more.util.StringUtils;

public class ResourceHttpServlet
extends HttpServlet {
    private static final long serialVersionUID = 2470188139577613256L;
    private static ContextClassLoaderLocal<ResourceLoader[]> LoaderList = new ContextClassLoaderLocal();
    private static ContextClassLoaderLocal<File> CacheDir = new ContextClassLoaderLocal();
    private Map<String, ReadWriteLock> cachingRes = new HashMap<String, ReadWriteLock>();
    @Inject
    private AppContext appContext;
    private boolean isDebug;

    public synchronized void init(ServletConfig config) throws ServletException {
        this.isDebug = this.appContext.getEnvironment().isDebug();
        ResourceLoader[] resLoaderArray = (ResourceLoader[])LoaderList.get();
        if (resLoaderArray != null) {
            return;
        }
        ResourceLoaderFactory factory = (ResourceLoaderFactory)this.appContext.getInstance(ResourceLoaderFactory.class);
        resLoaderArray = factory.loaderArray(this.appContext);
        if (resLoaderArray != null && resLoaderArray.length != 0) {
            LoaderList.set((Object)resLoaderArray);
        }
    }

    public static synchronized void initCacheDir(File cacheDir) {
        FileUtils.deleteDir((File)cacheDir);
        cacheDir.mkdirs();
        CacheDir.set((Object)cacheDir);
        Hasor.logInfo((String)"use cacheDir %s", (Object[])new Object[]{cacheDir});
    }

    private void forwardTo(File file, ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (response.isCommitted()) {
            return;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        String requestURI = req.getRequestURI();
        String fileExt = requestURI.substring(requestURI.lastIndexOf("."));
        String typeMimeType = req.getSession(true).getServletContext().getMimeType(fileExt);
        if (StringUtils.isBlank((String)typeMimeType)) {
            Hasor.logError((String)"%s not mapping MimeType!", (Object[])new Object[]{requestURI});
        }
        if (typeMimeType != null) {
            response.setContentType(typeMimeType);
        }
        FileInputStream cacheFile = new FileInputStream(file);
        IOUtils.copy((InputStream)cacheFile, (OutputStream)response.getOutputStream());
        cacheFile.close();
    }

    private synchronized ReadWriteLock getReadWriteLock(String requestURI) {
        ReadWriteLock cacheRWLock = null;
        if (this.cachingRes.containsKey(requestURI)) {
            cacheRWLock = this.cachingRes.get(requestURI);
        } else {
            cacheRWLock = new ReentrantReadWriteLock();
            this.cachingRes.put(requestURI, cacheRWLock);
        }
        return cacheRWLock;
    }

    private synchronized void releaseReadWriteLock(String requestURI) {
        if (this.cachingRes.containsKey(requestURI)) {
            this.cachingRes.remove(requestURI);
        }
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String requestURI = req.getRequestURI();
        try {
            requestURI = URLDecoder.decode(requestURI, "utf-8");
        }
        catch (Exception e) {
            // empty catch block
        }
        File cacheFile = new File((File)CacheDir.get(), requestURI);
        if (this.isDebug) {
            boolean mark = this.cacheRes(cacheFile, requestURI, request, response);
            if (mark) {
                this.forwardTo(cacheFile, request, response);
            } else {
                ((HttpServletResponse)response).sendError(404, "not exist :" + requestURI);
            }
            return;
        }
        ReadWriteLock cacheRWLock = this.getReadWriteLock(requestURI);
        boolean forwardType = true;
        cacheRWLock.readLock().lock();
        if (!cacheFile.exists()) {
            cacheRWLock.readLock().unlock();
            cacheRWLock.writeLock().lock();
            if (this.isDebug || !cacheFile.exists()) {
                forwardType = this.cacheRes(cacheFile, requestURI, request, response);
            }
            cacheRWLock.readLock().lock();
            cacheRWLock.writeLock().unlock();
        }
        cacheRWLock.readLock().unlock();
        if (forwardType) {
            this.forwardTo(cacheFile, request, response);
        } else {
            ((HttpServletResponse)response).sendError(404, "not exist this resource \u2018" + requestURI + "\u2019");
        }
        this.releaseReadWriteLock(requestURI);
    }

    private boolean cacheRes(File cacheFile, String requestURI, ServletRequest request, ServletResponse response) throws IOException, ServletException {
        ResourceLoader inLoader = null;
        InputStream inStream = null;
        ResourceLoader[] loaderList = (ResourceLoader[])LoaderList.get();
        if (loaderList == null || loaderList.length == 0) {
            return false;
        }
        for (ResourceLoader loader : loaderList) {
            if (!loader.exist(requestURI)) continue;
            if (this.isDebug && !loader.canModify(requestURI) && cacheFile.exists()) {
                return true;
            }
            inLoader = loader;
            inStream = loader.getResourceAsStream(requestURI);
            if (inStream != null) break;
        }
        if (inStream == null) {
            return false;
        }
        cacheFile.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(cacheFile);
        IOUtils.copy(inStream, (OutputStream)out);
        inLoader.close(inStream);
        out.flush();
        out.close();
        return true;
    }
}

