/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.controller.support;

import com.google.inject.Inject;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.AppContext;
import net.hasor.core.Hasor;
import net.hasor.plugins.controller.AbstractController;
import net.hasor.plugins.controller.Controller;
import net.hasor.plugins.controller.ControllerException;
import net.hasor.plugins.controller.ControllerIgnore;
import net.hasor.plugins.controller.ControllerInvoke;
import net.hasor.plugins.controller.support.ControllerNameSpace;
import net.hasor.plugins.controller.support.ControllerSettings;
import org.more.util.ArrayUtils;
import org.more.util.BeanUtils;
import org.more.util.StringUtils;
import org.more.util.exception.ExceptionUtils;

class ControllerServlet
extends HttpServlet {
    private static final long serialVersionUID = -8402094243884745631L;
    @Inject
    private AppContext appContext = null;
    private ControllerNameSpace[] spaceMap = null;
    public static final String REQUEST_DISPATCHER_REQUEST = "javax.servlet.forward.servlet_path";

    ControllerServlet() {
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String requestPath = request.getRequestURI().substring(request.getContextPath().length());
        ControllerInvoke invoke = this.getActionInvoke(requestPath, request.getMethod());
        if (invoke == null) {
            String logInfo = String.format("%s action is not defined.", requestPath);
            throw new ControllerException(logInfo);
        }
        this.doInvoke(invoke, (ServletRequest)request, (ServletResponse)response);
    }

    private void doInvoke(ControllerInvoke invoke, ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        try {
            invoke.invoke((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
        }
        catch (Throwable e) {
            Throwable target = ExceptionUtils.getCause((Throwable)e);
            Throwable throwable = target = target == null ? e : target;
            if (target instanceof ServletException) {
                throw (ServletException)target;
            }
            if (target instanceof IOException) {
                throw (ServletException)target;
            }
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            throw new ServletException(target);
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ControllerSettings settings = (ControllerSettings)this.appContext.getInstance(ControllerSettings.class);
        Set controllerSet = this.appContext.findClass(Controller.class);
        if (controllerSet == null) {
            return;
        }
        Object[] ignoreMethods = settings.getIgnoreMethod().toArray();
        HashMap<String, ControllerNameSpace> nsMap = new HashMap<String, ControllerNameSpace>();
        for (Class controllerType : controllerSet) {
            if (!AbstractController.class.isAssignableFrom(controllerType)) continue;
            Controller controllerAnno = controllerType.getAnnotation(Controller.class);
            String namespace = controllerAnno.value();
            namespace = StringUtils.isBlank((String)namespace) ? "/" : (namespace.charAt(namespace.length() - 1) == '/' ? namespace : namespace + "/");
            ControllerNameSpace nameSpace = (ControllerNameSpace)nsMap.get(namespace);
            if (nameSpace == null) {
                nameSpace = new ControllerNameSpace(namespace);
                nsMap.put(namespace, nameSpace);
            }
            List actionMethods = BeanUtils.getMethods((Class)controllerType);
            for (Method targetMethod : actionMethods) {
                if (ArrayUtils.contains((Object[])ignoreMethods, (Object)targetMethod.getName()) || targetMethod.getAnnotation(ControllerIgnore.class) != null) continue;
                nameSpace.addAction(targetMethod, this.appContext);
            }
        }
        for (ControllerNameSpace nsItem : nsMap.values()) {
            Hasor.logInfo((String)"found ControllerNameSpace %s.", (Object[])new Object[]{nsItem.toString()});
        }
        this.spaceMap = nsMap.values().toArray(new ControllerNameSpace[nsMap.size()]);
    }

    private ControllerInvoke getActionInvoke(String requestPath, String httpMethod) {
        String actionNS = requestPath.substring(0, requestPath.lastIndexOf("/") + 1);
        String actionInvoke = requestPath.substring(requestPath.lastIndexOf("/") + 1);
        String actionMethod = actionInvoke.split("\\.")[0];
        for (ControllerNameSpace ns : this.spaceMap) {
            if (!StringUtils.equalsIgnoreCase((String)ns.getNameSpace(), (String)actionNS)) continue;
            return ns.getActionByName(actionMethod);
        }
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String path, String httpMethod) {
        final String newRequestUri = path;
        final ControllerInvoke define = this.getActionInvoke(path, httpMethod);
        if (define == null) {
            return null;
        }
        return new RequestDispatcher(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                servletRequest.setAttribute(ControllerServlet.REQUEST_DISPATCHER_REQUEST, (Object)Boolean.TRUE);
                try {
                    ControllerServlet.this.doInvoke(define, servletRequest, servletResponse);
                }
                finally {
                    servletRequest.removeAttribute(ControllerServlet.REQUEST_DISPATCHER_REQUEST);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                if (servletResponse.isCommitted()) {
                    throw new ServletException("Response has been committed--you can only call forward before committing the response (hint: don't flush buffers)");
                }
                servletResponse.resetBuffer();
                Object requestToProcess = servletRequest instanceof HttpServletRequest ? new RequestDispatcherRequestWrapper(servletRequest, newRequestUri) : servletRequest;
                servletRequest.setAttribute(ControllerServlet.REQUEST_DISPATCHER_REQUEST, (Object)Boolean.TRUE);
                try {
                    ControllerServlet.this.doInvoke(define, requestToProcess, servletResponse);
                }
                finally {
                    servletRequest.removeAttribute(ControllerServlet.REQUEST_DISPATCHER_REQUEST);
                }
            }
        };
    }

    private static class RequestDispatcherRequestWrapper
    extends HttpServletRequestWrapper {
        private final String newRequestUri;

        public RequestDispatcherRequestWrapper(ServletRequest servletRequest, String newRequestUri) {
            super((HttpServletRequest)servletRequest);
            this.newRequestUri = newRequestUri;
        }

        public String getRequestURI() {
            return this.newRequestUri;
        }
    }
}

