/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.controller;

import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.hasor.core.AppContext;
import net.hasor.plugins.controller.ControllerIgnore;
import net.hasor.web.startup.RuntimeFilter;

public abstract class AbstractController {
    private ThreadLocal<HttpServletRequest> httpRequest = new ThreadLocal();
    private ThreadLocal<HttpServletResponse> httpResponse = new ThreadLocal();

    @ControllerIgnore
    public void initController(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.resetController();
        this.httpRequest.set(httpRequest);
        this.httpResponse.set(httpResponse);
    }

    @ControllerIgnore
    public void resetController() {
        if (this.httpRequest.get() != null) {
            this.httpRequest.remove();
        }
        if (this.httpResponse.get() != null) {
            this.httpResponse.remove();
        }
    }

    @ControllerIgnore
    public HttpServletRequest getRequest() {
        return this.httpRequest.get();
    }

    @ControllerIgnore
    public HttpServletResponse getResponse() {
        return this.httpResponse.get();
    }

    @ControllerIgnore
    public AppContext getAppContext() {
        return RuntimeFilter.getLocalAppContext();
    }

    @ControllerIgnore
    public HttpSession getSession() {
        return this.getRequest().getSession();
    }

    @ControllerIgnore
    public HttpSession getSession(boolean create) {
        return this.getRequest().getSession(create);
    }

    @ControllerIgnore
    public AbstractController putAtt(String attKey, Object attValue) {
        this.getRequest().setAttribute(attKey, attValue);
        return this;
    }

    @ControllerIgnore
    public AbstractController setHeader(String key, String value) {
        this.getResponse().setHeader(key, value);
        return this;
    }

    @ControllerIgnore
    public AbstractController addHeader(String key, String value) {
        this.getResponse().addHeader(key, value);
        return this;
    }

    @ControllerIgnore
    public AbstractController setAttr(String name, Object value) {
        this.getRequest().setAttribute(name, value);
        return this;
    }

    @ControllerIgnore
    public AbstractController removeAttr(String name) {
        this.getRequest().removeAttribute(name);
        return this;
    }

    @ControllerIgnore
    public AbstractController setAttrs(Map<String, Object> attrMap) {
        for (Map.Entry<String, Object> entry : attrMap.entrySet()) {
            this.getRequest().setAttribute(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @ControllerIgnore
    public String getPara(String name) {
        return this.getRequest().getParameter(name);
    }

    @ControllerIgnore
    public String getPara(String name, String defaultValue) {
        String result = this.getRequest().getParameter(name);
        return result != null && !"".equals(result) ? result : defaultValue;
    }

    @ControllerIgnore
    public Map<String, String[]> getParaMap() {
        return this.getRequest().getParameterMap();
    }

    @ControllerIgnore
    public Enumeration<String> getParaNames() {
        return this.getRequest().getParameterNames();
    }

    @ControllerIgnore
    public String[] getParaValues(String name) {
        return this.getRequest().getParameterValues(name);
    }

    @ControllerIgnore
    public Integer[] getParaValuesToInt(String name) {
        String[] values = this.getRequest().getParameterValues(name);
        if (values == null) {
            return null;
        }
        Integer[] result = new Integer[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Integer.parseInt(values[i]);
        }
        return result;
    }

    @ControllerIgnore
    public Enumeration<String> getAttrNames() {
        return this.getRequest().getAttributeNames();
    }

    @ControllerIgnore
    public <T> T getAttr(String name) {
        return (T)this.getRequest().getAttribute(name);
    }

    @ControllerIgnore
    public String getAttrForStr(String name) {
        return (String)this.getRequest().getAttribute(name);
    }

    @ControllerIgnore
    public Integer getAttrForInt(String name) {
        return (Integer)this.getRequest().getAttribute(name);
    }

    @ControllerIgnore
    public Integer toInt(String value, Integer defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value.startsWith("N") || value.startsWith("n")) {
            return -Integer.parseInt(value.substring(1));
        }
        return Integer.parseInt(value);
    }

    @ControllerIgnore
    public Integer getParaToInt(String name) {
        return this.toInt(this.getRequest().getParameter(name), null);
    }

    @ControllerIgnore
    public Integer getParaToInt(String name, Integer defaultValue) {
        return this.toInt(this.getRequest().getParameter(name), defaultValue);
    }

    @ControllerIgnore
    public Long toLong(String value, Long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value.startsWith("N") || value.startsWith("n")) {
            return -Long.parseLong(value.substring(1));
        }
        return Long.parseLong(value);
    }

    @ControllerIgnore
    public Long getParaToLong(String name) {
        return this.toLong(this.getRequest().getParameter(name), null);
    }

    @ControllerIgnore
    public Long getParaToLong(String name, Long defaultValue) {
        return this.toLong(this.getRequest().getParameter(name), defaultValue);
    }

    @ControllerIgnore
    public Boolean getParaToBoolean(String name) {
        String result = this.getRequest().getParameter(name);
        if (result != null) {
            if ((result = result.trim().toLowerCase()).equals("1") || result.equals("true")) {
                return Boolean.TRUE;
            }
            if (result.equals("0") || result.equals("false")) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    @ControllerIgnore
    public Boolean getParaToBoolean(String name, Boolean defaultValue) {
        Boolean result = this.getParaToBoolean(name);
        return result != null ? result : defaultValue;
    }

    @ControllerIgnore
    public <T> T getSessionAttr(String key) {
        HttpSession session = this.getRequest().getSession(false);
        return (T)(session != null ? session.getAttribute(key) : null);
    }

    @ControllerIgnore
    public AbstractController setSessionAttr(String key, Object value) {
        this.getRequest().getSession(true).setAttribute(key, value);
        return this;
    }

    @ControllerIgnore
    public AbstractController removeSessionAttr(String key) {
        HttpSession session = this.getRequest().getSession(false);
        if (session != null) {
            session.removeAttribute(key);
        }
        return this;
    }

    @ControllerIgnore
    public String getCookie(String name, String defaultValue) {
        Cookie cookie = this.getCookieObject(name);
        return cookie != null ? cookie.getValue() : defaultValue;
    }

    @ControllerIgnore
    public String getCookie(String name) {
        return this.getCookie(name, null);
    }

    @ControllerIgnore
    public Integer getCookieToInt(String name) {
        String result = this.getCookie(name);
        return result != null ? Integer.valueOf(Integer.parseInt(result)) : null;
    }

    @ControllerIgnore
    public Integer getCookieToInt(String name, Integer defaultValue) {
        String result = this.getCookie(name);
        return result != null ? Integer.parseInt(result) : defaultValue;
    }

    @ControllerIgnore
    public Long getCookieToLong(String name) {
        String result = this.getCookie(name);
        return result != null ? Long.valueOf(Long.parseLong(result)) : null;
    }

    @ControllerIgnore
    public Long getCookieToLong(String name, Long defaultValue) {
        String result = this.getCookie(name);
        return result != null ? Long.parseLong(result) : defaultValue;
    }

    @ControllerIgnore
    public Cookie getCookieObject(String name) {
        Cookie[] cookies = this.getRequest().getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
        }
        return null;
    }

    @ControllerIgnore
    public Cookie[] getCookieObjects() {
        Cookie[] result = this.getRequest().getCookies();
        return result != null ? result : new Cookie[]{};
    }

    @ControllerIgnore
    public AbstractController setCookie(Cookie cookie) {
        this.getResponse().addCookie(cookie);
        return this;
    }

    @ControllerIgnore
    public AbstractController setCookie(String name, String value, int maxAgeInSeconds, String path) {
        this.setCookie(name, value, maxAgeInSeconds, path, null);
        return this;
    }

    @ControllerIgnore
    public AbstractController setCookie(String name, String value, int maxAgeInSeconds, String path, String domain) {
        Cookie cookie = new Cookie(name, value);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        cookie.setMaxAge(maxAgeInSeconds);
        cookie.setPath(path);
        this.getResponse().addCookie(cookie);
        return this;
    }

    @ControllerIgnore
    public AbstractController setCookie(String name, String value, int maxAgeInSeconds) {
        this.setCookie(name, value, maxAgeInSeconds, "/", null);
        return this;
    }

    @ControllerIgnore
    public AbstractController removeCookie(String name) {
        this.setCookie(name, null, 0, "/", null);
        return this;
    }

    @ControllerIgnore
    public AbstractController removeCookie(String name, String path) {
        this.setCookie(name, null, 0, path, null);
        return this;
    }

    @ControllerIgnore
    public AbstractController removeCookie(String name, String path, String domain) {
        this.setCookie(name, null, 0, path, domain);
        return this;
    }

    @ControllerIgnore
    protected Object getModel(Class<?> modelClass) {
        return this.getAppContext().getInstance(modelClass);
    }

    @ControllerIgnore
    protected Object getModel(String modelName) {
        return this.getAppContext().getBean(modelName);
    }
}

