/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.servlet.startup;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import net.hasor.Hasor;
import net.hasor.core.AppContext;
import net.hasor.core.context.AbstractAppContext;
import net.hasor.web.servlet.binder.SessionListenerPipeline;
import net.hasor.web.servlet.context.AnnoWebAppContext;

public class RuntimeListener
implements ServletContextListener,
HttpSessionListener {
    public static final String AppContextName = AppContext.class.getName();
    private AbstractAppContext appContext = null;
    private SessionListenerPipeline sessionListenerPipeline = null;

    protected AbstractAppContext createAppContext(ServletContext sc) throws IOException {
        AnnoWebAppContext webContext = new AnnoWebAppContext("hasor-config.xml", sc);
        return webContext;
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            this.appContext = this.createAppContext(servletContextEvent.getServletContext());
            this.appContext.start();
        }
        catch (Exception e) {
            Hasor.error((String)"createAppContext error.\n%s", (Object[])new Object[]{e});
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        this.sessionListenerPipeline = (SessionListenerPipeline)this.appContext.getInstance(SessionListenerPipeline.class);
        this.sessionListenerPipeline.init((AppContext)this.appContext);
        Hasor.info((String)"sessionListenerPipeline created.", (Object[])new Object[0]);
        Hasor.info((String)("ServletContext Attribut : " + AppContextName + " -->> " + Hasor.logString((Object)this.appContext)), (Object[])new Object[0]);
        servletContextEvent.getServletContext().setAttribute(AppContextName, (Object)this.appContext);
        this.sessionListenerPipeline.contextInitialized(servletContextEvent);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        this.sessionListenerPipeline.contextDestroyed(servletContextEvent);
        this.appContext.stop();
    }

    public void sessionCreated(HttpSessionEvent se) {
        this.sessionListenerPipeline.sessionCreated(se);
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        this.sessionListenerPipeline.sessionDestroyed(se);
    }
}

