/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.servlet.context;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import net.hasor.core.ApiBinder;
import net.hasor.core.Environment;
import net.hasor.core.ModuleInfo;
import net.hasor.core.binder.ApiBinderModule;
import net.hasor.core.context.AnnoStandardAppContext;
import net.hasor.core.module.AbstractModulePropxy;
import net.hasor.web.servlet.binder.FilterPipeline;
import net.hasor.web.servlet.binder.SessionListenerPipeline;
import net.hasor.web.servlet.binder.support.ManagedFilterPipeline;
import net.hasor.web.servlet.binder.support.ManagedServletPipeline;
import net.hasor.web.servlet.binder.support.ManagedSessionListenerPipeline;
import net.hasor.web.servlet.binder.support.WebApiBinderModule;
import net.hasor.web.servlet.context.WebStandardEnvironment;

public class AnnoWebAppContext
extends AnnoStandardAppContext {
    public AnnoWebAppContext() throws IOException {
    }

    public AnnoWebAppContext(ServletContext servletContext) throws IOException {
        this((String)null, servletContext);
    }

    public AnnoWebAppContext(String mainSettings) throws IOException {
        super(mainSettings);
    }

    public AnnoWebAppContext(File mainSettings) {
        super(mainSettings);
    }

    public AnnoWebAppContext(URI mainSettings) {
        super(mainSettings);
    }

    public AnnoWebAppContext(String mainSettings, ServletContext servletContext) throws IOException {
        super(mainSettings, (Object)servletContext);
    }

    public AnnoWebAppContext(File mainSettings, ServletContext servletContext) {
        super(mainSettings, (Object)servletContext);
    }

    public AnnoWebAppContext(URI mainSettings, ServletContext servletContext) {
        super(mainSettings, (Object)servletContext);
    }

    public ServletContext getServletContext() {
        if (this.getContext() instanceof ServletContext) {
            return (ServletContext)this.getContext();
        }
        return null;
    }

    protected Environment createEnvironment() {
        return new WebStandardEnvironment(this.getMainSettings(), this.getServletContext());
    }

    protected Injector createInjector(Module[] guiceModules) {
        Module webModule = new Module(){

            public void configure(Binder binder) {
                binder.bind(ManagedServletPipeline.class);
                binder.bind(FilterPipeline.class).to(ManagedFilterPipeline.class);
                binder.bind(SessionListenerPipeline.class).to(ManagedSessionListenerPipeline.class);
                binder.bind(ServletContext.class).toProvider((Provider)new Provider<ServletContext>(){

                    public ServletContext get() {
                        return AnnoWebAppContext.this.getServletContext();
                    }
                });
            }
        };
        ArrayList<Module> guiceModuleSet = new ArrayList<Module>();
        guiceModuleSet.add(webModule);
        if (guiceModules != null) {
            for (Module mod : guiceModules) {
                guiceModuleSet.add(mod);
            }
        }
        return super.createInjector(guiceModuleSet.toArray(new Module[guiceModuleSet.size()]));
    }

    protected ApiBinderModule newApiBinder(final AbstractModulePropxy forModule, final Binder binder) {
        return new WebApiBinderModule(this.getEnvironment(), (ModuleInfo)forModule){

            public Binder getGuiceBinder() {
                return binder;
            }

            public ApiBinder.DependencySettings dependency() {
                return forModule;
            }
        };
    }
}

