/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.servlet.binder.support;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.hasor.web.servlet.binder.support.UriPatternMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum UriPatternType {
    SERVLET,
    REGEX;


    static UriPatternMatcher get(UriPatternType type, String pattern) {
        switch (type) {
            case SERVLET: {
                return new ServletStyleUriPatternMatcher(pattern);
            }
            case REGEX: {
                return new RegexUriPatternMatcher(pattern);
            }
        }
        return null;
    }

    private static class RegexUriPatternMatcher
    implements UriPatternMatcher {
        private final Pattern pattern;

        public RegexUriPatternMatcher(String pattern) {
            this.pattern = Pattern.compile(pattern);
        }

        public boolean matches(String uri) {
            return null != uri && this.pattern.matcher(uri).matches();
        }

        public String extractPath(String path) {
            int end;
            Matcher matcher = this.pattern.matcher(path);
            if (matcher.matches() && matcher.groupCount() >= 1 && (end = matcher.start(1)) < path.length()) {
                return path.substring(0, end);
            }
            return null;
        }

        public UriPatternType getPatternType() {
            return REGEX;
        }
    }

    private static class ServletStyleUriPatternMatcher
    implements UriPatternMatcher {
        private final String pattern;
        private final Kind patternKind;

        public ServletStyleUriPatternMatcher(String pattern) {
            if (pattern.startsWith("*")) {
                this.pattern = pattern.substring(1);
                this.patternKind = Kind.PREFIX;
            } else if (pattern.endsWith("*")) {
                this.pattern = pattern.substring(0, pattern.length() - 1);
                this.patternKind = Kind.SUFFIX;
            } else if (pattern.startsWith("/")) {
                this.pattern = pattern;
                this.patternKind = Kind.WITHROOT;
            } else {
                this.pattern = pattern;
                this.patternKind = Kind.LITERAL;
            }
        }

        public boolean matches(String uri) {
            if (null == uri) {
                return false;
            }
            if (this.patternKind == Kind.PREFIX) {
                return uri.endsWith(this.pattern);
            }
            if (this.patternKind == Kind.SUFFIX) {
                return uri.startsWith(this.pattern);
            }
            if (this.patternKind == Kind.WITHROOT) {
                return this.pattern.equals(uri);
            }
            return this.pattern.equals(uri.substring(1));
        }

        public String extractPath(String path) {
            if (this.patternKind == Kind.PREFIX) {
                return null;
            }
            if (this.patternKind == Kind.SUFFIX) {
                String extract = this.pattern;
                if (extract.endsWith("/")) {
                    extract = extract.substring(0, extract.length() - 1);
                }
                return extract;
            }
            return path;
        }

        public UriPatternType getPatternType() {
            return SERVLET;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Kind {
            PREFIX,
            SUFFIX,
            LITERAL,
            WITHROOT;

        }
    }
}

