/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.servlet.binder.support;

import com.google.inject.Key;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.hasor.core.AppContext;
import net.hasor.web.servlet.binder.support.AbstractServletModuleBinding;
import net.hasor.web.servlet.binder.support.UriPatternMatcher;
import org.more.util.Iterators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServletDefinition
extends AbstractServletModuleBinding
implements Provider<ServletDefinition> {
    private Key<? extends HttpServlet> servletKey = null;
    private HttpServlet servletInstance = null;
    private UriPatternMatcher patternMatcher = null;
    private AppContext appContext = null;

    public ServletDefinition(int index, String pattern, Key<? extends HttpServlet> servletKey, UriPatternMatcher uriPatternMatcher, Map<String, String> initParams, HttpServlet servletInstance) {
        super(index, initParams, pattern, uriPatternMatcher);
        this.servletKey = servletKey;
        this.servletInstance = servletInstance;
        this.patternMatcher = uriPatternMatcher;
    }

    public ServletDefinition get() {
        return this;
    }

    protected HttpServlet getTarget(AppContext appContext) {
        if (this.servletInstance == null) {
            this.servletInstance = (HttpServlet)appContext.getGuice().getInstance(this.servletKey);
        }
        return this.servletInstance;
    }

    public String toString() {
        return String.format("type %s pattern=%s ,initParams=%s ,uriPatternType=%s", new Object[]{ServletDefinition.class, this.getPattern(), this.getInitParams(), this.getUriPatternType()});
    }

    public void init(final AppContext appContext) throws ServletException {
        this.appContext = appContext;
        HttpServlet servlet = this.getTarget(appContext);
        if (servlet == null) {
            return;
        }
        final Map<String, String> initParams = this.getInitParams();
        servlet.init(new ServletConfig(){

            public String getServletName() {
                return ServletDefinition.this.servletKey.toString();
            }

            public ServletContext getServletContext() {
                Object context = appContext.getContext();
                if (context instanceof ServletContext) {
                    return (ServletContext)context;
                }
                return null;
            }

            public String getInitParameter(String s) {
                return (String)initParams.get(s);
            }

            public Enumeration<String> getInitParameterNames() {
                return Iterators.asEnumeration(initParams.keySet().iterator());
            }
        });
    }

    public boolean service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String path = httpRequest.getRequestURI().substring(httpRequest.getContextPath().length());
        boolean serve = this.matchesUri(path);
        if (serve) {
            this.doService(request, response);
        }
        return serve;
    }

    private void doService(final ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        HttpServletRequestWrapper request = new HttpServletRequestWrapper((HttpServletRequest)servletRequest){
            private String path;
            private boolean pathComputed;
            private boolean pathInfoComputed;
            private String pathInfo;
            {
                super(x0);
                this.pathComputed = false;
                this.pathInfoComputed = false;
            }

            public String getPathInfo() {
                if (!this.isPathInfoComputed()) {
                    int servletPathLength = this.getServletPath().length();
                    this.pathInfo = this.getRequestURI().substring(this.getContextPath().length()).replaceAll("[/]{2,}", "/");
                    String string = this.pathInfo = this.pathInfo.length() > servletPathLength ? this.pathInfo.substring(servletPathLength) : null;
                    if ("".equals(this.pathInfo) && servletPathLength != 0) {
                        this.pathInfo = null;
                    }
                    this.pathInfoComputed = true;
                }
                return this.pathInfo;
            }

            private boolean isPathInfoComputed() {
                return this.pathInfoComputed && null == servletRequest.getAttribute("javax.servlet.forward.servlet_path");
            }

            private boolean isPathComputed() {
                return this.pathComputed && null == servletRequest.getAttribute("javax.servlet.forward.servlet_path");
            }

            public String getServletPath() {
                return this.computePath();
            }

            public String getPathTranslated() {
                String info = this.getPathInfo();
                return null == info ? null : this.getRealPath(info);
            }

            private String computePath() {
                if (!this.isPathComputed()) {
                    String servletPath = super.getServletPath();
                    this.path = ServletDefinition.this.patternMatcher.extractPath(servletPath);
                    this.pathComputed = true;
                    if (null == this.path) {
                        this.path = servletPath;
                    }
                }
                return this.path;
            }
        };
        HttpServlet servlet = this.getTarget(this.appContext);
        if (servlet == null) {
            return;
        }
        servlet.service((ServletRequest)request, servletResponse);
    }

    public void destroy(AppContext appContext) {
        HttpServlet servlet = this.getTarget(appContext);
        if (servlet == null) {
            return;
        }
        servlet.destroy();
    }
}

