/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.servlet.binder.support;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import java.util.ArrayList;
import javax.inject.Singleton;
import javax.servlet.ServletContextEvent;
import javax.servlet.http.HttpSessionEvent;
import net.hasor.core.AppContext;
import net.hasor.web.servlet.binder.SessionListenerPipeline;
import net.hasor.web.servlet.binder.support.ContextListenerDefinition;
import net.hasor.web.servlet.binder.support.HttpSessionListenerDefinition;

@Singleton
public class ManagedSessionListenerPipeline
implements SessionListenerPipeline {
    private HttpSessionListenerDefinition[] sessionListeners = null;
    private ContextListenerDefinition[] contextListeners = null;
    private volatile boolean initialized = false;
    private AppContext appContext = null;

    public void init(AppContext appContext) {
        if (this.initialized) {
            return;
        }
        this.appContext = appContext;
        this.sessionListeners = this.collectListenerDefinitions(appContext.getGuice());
        this.contextListeners = this.collectContextListenerDefinitions(appContext.getGuice());
        this.initialized = true;
    }

    private HttpSessionListenerDefinition[] collectListenerDefinitions(Injector injector) {
        ArrayList<Object> sessionListeners = new ArrayList<Object>();
        TypeLiteral LISTENER_DEFS = TypeLiteral.get(HttpSessionListenerDefinition.class);
        for (Binding entry : injector.findBindingsByType(LISTENER_DEFS)) {
            sessionListeners.add(entry.getProvider().get());
        }
        return sessionListeners.toArray(new HttpSessionListenerDefinition[sessionListeners.size()]);
    }

    private ContextListenerDefinition[] collectContextListenerDefinitions(Injector injector) {
        ArrayList<Object> contextListeners = new ArrayList<Object>();
        TypeLiteral LISTENER_DEFS = TypeLiteral.get(ContextListenerDefinition.class);
        for (Binding entry : injector.findBindingsByType(LISTENER_DEFS)) {
            contextListeners.add(entry.getProvider().get());
        }
        return contextListeners.toArray(new ContextListenerDefinition[contextListeners.size()]);
    }

    public void sessionCreated(HttpSessionEvent event) {
        if (!this.initialized) {
            return;
        }
        for (HttpSessionListenerDefinition httpSessionListenerDefinition : this.sessionListeners) {
            httpSessionListenerDefinition.sessionCreated(this.appContext, event);
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (!this.initialized) {
            return;
        }
        for (HttpSessionListenerDefinition httpSessionListenerDefinition : this.sessionListeners) {
            httpSessionListenerDefinition.sessionDestroyed(this.appContext, event);
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        if (!this.initialized) {
            return;
        }
        for (ContextListenerDefinition contextListenerDefinition : this.contextListeners) {
            contextListenerDefinition.contextInitialized(this.appContext, event);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (!this.initialized) {
            return;
        }
        for (ContextListenerDefinition contextListenerDefinition : this.contextListeners) {
            contextListenerDefinition.contextDestroyed(this.appContext, event);
        }
    }
}

