/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.servlet.binder.support;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.inject.Singleton;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.hasor.core.AppContext;
import net.hasor.web.servlet.binder.support.ServletDefinition;

@Singleton
public class ManagedServletPipeline {
    private ServletDefinition[] servletDefinitions;
    private volatile boolean initialized = false;
    public static final String REQUEST_DISPATCHER_REQUEST = "javax.servlet.forward.servlet_path";

    public synchronized void initPipeline(AppContext appContext) throws ServletException {
        if (this.initialized) {
            return;
        }
        for (ServletDefinition servletDefinition : this.servletDefinitions = this.collectServletDefinitions(appContext.getGuice())) {
            servletDefinition.init(appContext);
        }
        this.initialized = true;
    }

    private ServletDefinition[] collectServletDefinitions(Injector injector) {
        ArrayList<Object> servletDefinitions = new ArrayList<Object>();
        TypeLiteral SERVLET_DEFS = TypeLiteral.get(ServletDefinition.class);
        for (Binding entry : injector.findBindingsByType(SERVLET_DEFS)) {
            servletDefinitions.add(entry.getProvider().get());
        }
        Collections.sort(servletDefinitions, new Comparator<ServletDefinition>(){

            @Override
            public int compare(ServletDefinition o1, ServletDefinition o2) {
                int o2Index;
                int o1Index = o1.getIndex();
                return o1Index < (o2Index = o2.getIndex()) ? -1 : (o1Index == o2Index ? 0 : 1);
            }
        });
        return servletDefinitions.toArray(new ServletDefinition[servletDefinitions.size()]);
    }

    public boolean hasServletsMapped() {
        return this.servletDefinitions.length > 0;
    }

    public boolean service(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        for (ServletDefinition servletDefinition : this.servletDefinitions) {
            if (!servletDefinition.service(servletRequest, servletResponse)) continue;
            return true;
        }
        return false;
    }

    public void destroyPipeline(AppContext appContext) {
        for (ServletDefinition servletDefinition : this.servletDefinitions) {
            servletDefinition.destroy(appContext);
        }
    }

    RequestDispatcher getRequestDispatcher(String path) {
        final String newRequestUri = path;
        for (final ServletDefinition servletDefinition : this.servletDefinitions) {
            if (!servletDefinition.matchesUri(path)) continue;
            return new RequestDispatcher(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                    Object requestToProcess;
                    if (servletResponse.isCommitted()) {
                        throw new ServletException("Response has been committed--you can only call forward before committing the response (hint: don't flush buffers)");
                    }
                    servletResponse.resetBuffer();
                    if (servletRequest instanceof HttpServletRequest) {
                        String servletPath = ((HttpServletRequest)servletRequest).getContextPath() + "/" + newRequestUri;
                        servletPath = servletPath.replaceAll("/{2,}", "/");
                        requestToProcess = new RequestDispatcherRequestWrapper(servletRequest, servletPath);
                    } else {
                        requestToProcess = servletRequest;
                    }
                    servletRequest.setAttribute(ManagedServletPipeline.REQUEST_DISPATCHER_REQUEST, (Object)Boolean.TRUE);
                    try {
                        servletDefinition.service((ServletRequest)requestToProcess, servletResponse);
                    }
                    finally {
                        servletRequest.removeAttribute(ManagedServletPipeline.REQUEST_DISPATCHER_REQUEST);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                    servletRequest.setAttribute(ManagedServletPipeline.REQUEST_DISPATCHER_REQUEST, (Object)Boolean.TRUE);
                    try {
                        servletDefinition.service(servletRequest, servletResponse);
                    }
                    finally {
                        servletRequest.removeAttribute(ManagedServletPipeline.REQUEST_DISPATCHER_REQUEST);
                    }
                }
            };
        }
        return null;
    }

    private static class RequestDispatcherRequestWrapper
    extends HttpServletRequestWrapper {
        private final String newRequestUri;

        public RequestDispatcherRequestWrapper(ServletRequest servletRequest, String newRequestUri) {
            super((HttpServletRequest)servletRequest);
            this.newRequestUri = newRequestUri;
        }

        public String getRequestURI() {
            return this.newRequestUri;
        }
    }
}

