/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.servlet.binder.support;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import net.hasor.core.AppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HttpSessionListenerDefinition
implements Provider<HttpSessionListenerDefinition> {
    private Key<? extends HttpSessionListener> listenerKey = null;
    private HttpSessionListener listenerInstance = null;

    public HttpSessionListenerDefinition(Key<? extends HttpSessionListener> listenerKey, HttpSessionListener listenerInstance) {
        this.listenerKey = listenerKey;
        this.listenerInstance = listenerInstance;
    }

    public HttpSessionListenerDefinition get() {
        return this;
    }

    protected HttpSessionListener getTarget(Injector injector) {
        if (this.listenerInstance == null) {
            this.listenerInstance = (HttpSessionListener)injector.getInstance(this.listenerKey);
        }
        return this.listenerInstance;
    }

    public String toString() {
        return String.format("type %s listenerKey=%s", HttpSessionListenerDefinition.class, this.listenerKey);
    }

    public void sessionCreated(AppContext appContext, HttpSessionEvent event) {
        HttpSessionListener httpSessionListener = this.getTarget(appContext.getGuice());
        if (httpSessionListener != null) {
            httpSessionListener.sessionCreated(event);
        }
    }

    public void sessionDestroyed(AppContext appContext, HttpSessionEvent event) {
        HttpSessionListener httpSessionListener = this.getTarget(appContext.getGuice());
        if (httpSessionListener != null) {
            httpSessionListener.sessionDestroyed(event);
        }
    }
}

