/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.servlet.binder.support;

import com.google.inject.Key;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import net.hasor.core.AppContext;
import net.hasor.web.servlet.binder.support.AbstractServletModuleBinding;
import net.hasor.web.servlet.binder.support.UriPatternMatcher;
import org.more.util.Iterators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilterDefinition
extends AbstractServletModuleBinding
implements Provider<FilterDefinition> {
    private Key<? extends Filter> filterKey = null;
    private Filter filterInstance = null;
    private AppContext appContext = null;

    public FilterDefinition(int index, String pattern, Key<? extends Filter> filterKey, UriPatternMatcher uriPatternMatcher, Map<String, String> initParams, Filter filterInstance) {
        super(index, initParams, pattern, uriPatternMatcher);
        this.filterKey = filterKey;
        this.filterInstance = filterInstance;
    }

    public FilterDefinition get() {
        return this;
    }

    protected Filter getTarget(final AppContext appContext) throws ServletException {
        if (this.filterInstance != null) {
            return this.filterInstance;
        }
        final Map<String, String> initParams = this.getInitParams();
        this.filterInstance = (Filter)appContext.getGuice().getInstance(this.filterKey);
        this.filterInstance.init(new FilterConfig(){

            public String getFilterName() {
                return FilterDefinition.this.filterKey.toString();
            }

            public ServletContext getServletContext() {
                Object context = appContext.getContext();
                if (context instanceof ServletContext) {
                    return (ServletContext)context;
                }
                return null;
            }

            public String getInitParameter(String s) {
                return (String)initParams.get(s);
            }

            public Enumeration<String> getInitParameterNames() {
                return Iterators.asEnumeration(initParams.keySet().iterator());
            }
        });
        return this.filterInstance;
    }

    public String toString() {
        return String.format("type %s pattern=%s ,initParams=%s ,uriPatternType=%s", new Object[]{FilterDefinition.class, this.getPattern(), this.getInitParams(), this.getUriPatternType()});
    }

    public void init(AppContext appContext) throws ServletException {
        this.appContext = appContext;
        this.getTarget(appContext);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String path = httpRequest.getRequestURI().substring(httpRequest.getContextPath().length());
        boolean serve = this.matchesUri(path);
        Filter filter = this.getTarget(this.appContext);
        if (serve && filter != null) {
            filter.doFilter(request, response, chain);
        } else {
            chain.doFilter((ServletRequest)httpRequest, response);
        }
    }

    public void destroy(AppContext appContext) {
        if (this.filterInstance == null) {
            return;
        }
        this.filterInstance.destroy();
    }
}

